<?php

namespace App\Actions\Documents;

use App\Note;
use Illuminate\Support\Collection;

class StoreDocumentsAction
{
    public function execute(Collection $collection)
    {
        try {

            $document = new Note();
            if ($collection->has('file')) {
                $document->file = $collection->get('file')->store('notes', 'uploads');

                $document->lead_id = $collection->get('lead_id');
                $document->type = $collection->get('doc_type');

                $document->updated_at = now();
            }

            if ($document->save()) {

                $activity_subject = auth()->user()->name . ' uploaded document with lead ID :' . $document->lead_id;
                \ActivityLog::addToLog($activity_subject, 'leads');
                return true;
            }
        } catch (\Throwable $th) {
            //throw $th;
            info($th);
            return false;
        }
    }
}
