<?php

namespace App\Actions\Documents;

use App\Note;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Storage;

class UpdateDocumentAction
{
    public function execute(Collection $collection)
    {
        try {
            $document = Note::find($collection->get('id'));

            $currentImage = $document->file;

            if ($collection->has('file')) {
                Storage::disk('uploads')->delete($currentImage);

                $document->file = $collection->get('file')->store('notes', 'uploads');

                $document->updated_at = now();
            }

            if ($document->save()) {

                $activity_subject = auth()->user()->name . ' updated document with document ID :' . $document->id . ' and lead ID :' . $document->lead_id;
                \ActivityLog::addToLog($activity_subject, 'leads');
                return true;
            }
        } catch (\Throwable $th) {
            //throw $th;
            return false;

            info($th);
        }
    }
}
