<?php

namespace App\Actions\MallSoftware\Company;

use App\Helpers\ActivityLog;
use App\Company;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class CreateCompanyAction
{
    public function execute(Collection $collection)
    {
        DB::beginTransaction();
        try {

            $company = new Company();

            $company->title = $collection->get('title');
            $company->short_name = $collection->get('short_name');
            $company->phone = $collection->get('phone');
            $company->email = $collection->get('email');
            $company->address = $collection->get('address');
            $company->pincode = $collection->get('pincode');
            $company->country_id = $collection->get('country_id');
            $company->state_id = $collection->get('state_id');
            $company->web_site = $collection->get('web_site');
            $company->location = $collection->get('location');
            $company->pan_no = $collection->get('pan_no');
            $company->tan = $collection->get('tan');
            $company->gst_in = $collection->get('gst_in');
            $company->pf_no = $collection->get('pf_no');
            $company->cin = $collection->get('cin');
            $company->contact_person = $collection->get('contact_person');
            $company->contact_phone = $collection->get('contact_phone');
            $company->parent_company_id = $collection->get('parent_company_id');
            $company->save();

            $activity_subject = auth()->user()->name . ' added new company with id ' . $company->id;
            ActivityLog::addToLog($activity_subject, 'finance');
            DB::commit();

            return true;
            //code...
        } catch (\Throwable $th) {
            info($th);

            DB::rollback();

            return false;
        }
    }
}
