<?php

namespace App\Actions\MallSoftware\LesseeEntry;

use App\LesseEntry;
use Illuminate\Support\Collection;

class LesseeEntryCompanyUpdateAction
{
    public function execute(Collection $collection, LesseEntry $lesseEntry)
    {
        try {
            $lesseEntry->lessee_type = $collection->get('lessee_entry_type');
            $lesseEntry->company_name = $collection->get('company_name');
            $lesseEntry->company_date_of_incorporation = $collection->get('date_of_incorporation');
            $lesseEntry->company_contact_number = $collection->get('company_contact');
            $lesseEntry->company_nationality = $collection->get('company_nationality');
            $lesseEntry->company_pan_number = $collection->get('company_pan_number');
            $lesseEntry->company_gst_number = $collection->get('company_gst_number');
            $lesseEntry->company_permanent_address = $collection->get('company_permanent_address');
            $lesseEntry->company_permanent_country_id = $collection->get('company_paddress_country');
            $lesseEntry->company_permanent_state_id = $collection->get('company_paddress_state');
            $lesseEntry->company_permanent_district_id = $collection->get('company_paddress_district') ? $collection->get('company_paddress_district') : 0;
            $lesseEntry->company_permanent_pincode = $collection->get('company_paddress_pincode');
            if ($collection->get('company_checkbox') == "1") {
                $lesseEntry->company_communication_address = $collection->get('company_permanent_address');
                $lesseEntry->company_communication_country_id = $collection->get('company_paddress_country');
                $lesseEntry->company_communication_state_id = $collection->get('company_paddress_state');
                $lesseEntry->company_communication_district_id = $collection->get('company_paddress_district') ? $collection->get('company_paddress_district') : 0;
                $lesseEntry->company_communication_pincode = $collection->get('company_paddress_pincode');
            } else {
                $lesseEntry->company_communication_address = $collection->get('company_communication_address');
                $lesseEntry->company_communication_country_id = $collection->get('company_caddress_country');
                $lesseEntry->company_communication_state_id = $collection->get('company_caddress_state');
                $lesseEntry->company_communication_district_id = $collection->get('company_caddress_district') ? $collection->get('company_caddress_district') : 0;
                $lesseEntry->company_communication_pincode = $collection->get('company_caddress_pincode');
            }
            $lesseEntry->save();
            return true;
        } catch (\Throwable $th) {
            info($th);
            return false;
        }
    }
}
