<?php

namespace App\Actions\MallSoftware\LesseeEntry;

use App\LesseEntry;
use Illuminate\Support\Collection;

class LesseeEntryIndividualUpdateAction
{
    public function execute(Collection $collection, LesseEntry $lesseEntry)
    {
        try {
            $lesseEntry->lessee_type = $collection->get('lessee_entry_type');
            $lesseEntry->individual_name = $collection->get('name');
            $lesseEntry->date_of_birth = $collection->get('date_of_birth');
            $lesseEntry->individual_contact_number = $collection->get('individual_contact');
            $lesseEntry->fathers_name = $collection->get('fathers_name');
            $lesseEntry->individual_nationality = $collection->get('individual_nationality');
            $lesseEntry->aadhar_number = $collection->get('aadhar_number');
            $lesseEntry->individual_pan_number = $collection->get('pan_number');
            $lesseEntry->individual_gstin = $collection->get('gstin');
            $lesseEntry->individual_permanent_address = $collection->get('individual_permanent_address');
            $lesseEntry->individual_permanent_country_id = $collection->get('individual_paddress_country');
            $lesseEntry->individual_permanent_state_id = $collection->get('individual_paddress_state');
            $lesseEntry->individual_permanent_district_id = $collection->get('individual_paddress_district') ? $collection->get('individual_paddress_district') : 0;
            $lesseEntry->individual_permanent_pincode = $collection->get('individual_paddress_pincode');
            if ($collection->get('individual_checkbox') == "1") {
                $lesseEntry->individual_communication_address = $collection->get('individual_permanent_address');
                $lesseEntry->individual_communication_country_id = $collection->get('individual_paddress_country');
                $lesseEntry->individual_communication_state_id = $collection->get('individual_paddress_state');
                $lesseEntry->individual_communication_district_id = $collection->get('individual_paddress_district') ? $collection->get('individual_paddress_district') : 0;
                $lesseEntry->individual_communication_pincode = $collection->get('individual_paddress_pincode');
            } else {
                $lesseEntry->individual_communication_address = $collection->get('individual_communication_address');
                $lesseEntry->individual_communication_country_id = $collection->get('individual_caddress_country');
                $lesseEntry->individual_communication_state_id = $collection->get('individual_caddress_state');
                $lesseEntry->individual_communication_district_id = $collection->get('individual_caddress_district') ? $collection->get('individual_caddress_district') : 0;
                $lesseEntry->individual_communication_pincode = $collection->get('individual_caddress_pincode');
            }
            $lesseEntry->save();
            return true;
        } catch (\Throwable $th) {
            dd($th);
            info($th);
            return false;
        }
    }
}
