<?php

namespace App\Actions\MallSoftware\RateItemDefinition;

use App\RateItemDefinition;
use Illuminate\Support\Collection;

class RateItemDefinitionStoreAction
{
    public function execute(Collection $collection)
    {
        try {
            $data = new RateItemDefinition();
            $data->rate_type = $collection->get('rate_type');
            $data->rate_item_name = $collection->get('rate_item_name');
            $data->rate_calculation_method = $collection->get('rate_calculation_method');
            $data->default_rate = $collection->get('default_rate');
            $data->remarks = $collection->get('remarks');
            $data->gst_percentage = $collection->get('gst_percentage');
            $data->tds_percentage = $collection->get('tds_percentage');
            $data->other_taxes = $collection->get('other_taxes');
            $data->due_days = $collection->get('due_days');
            $data->is_active = $collection->get('active') ? $collection->get('active') : 0;
            $data->hsn_sac_code = $collection->get('hsn-sac-code');
            $data->coa_group = $collection->get('group_select');
            $data->ledger_type = $collection->get('individual_ledger');
            $data->prefix = $collection->get('prefix');
            $data->company_shortname = 'cmp';
            $data->project_shortname = 'pjct';
            $data->financial_year = $collection->get('financial_year');
            $data->next_number = $collection->get('next_number');
            $data->save();
            return true;

        } catch (\Throwable $th) {
            dd($th);
            info($th);
            return false;
        }
    }
}
