<?php

namespace App\Actions\MallSoftware\RateItemDefinition;

use App\RateItemDefinition;
use Illuminate\Support\Collection;

class RateItemDefinitionUpdateAction
{
    public function execute(Collection $collection, RateItemDefinition $rateItemDefinition)
    {
        try {
            $rateItemDefinition->rate_type = $collection->get('rate_type');
            $rateItemDefinition->rate_item_name = $collection->get('rate_item_name');
            $rateItemDefinition->rate_calculation_method = $collection->get('rate_calculation_method');
            $rateItemDefinition->default_rate = $collection->get('default_rate');
            $rateItemDefinition->remarks = $collection->get('remarks');
            $rateItemDefinition->gst_percentage = $collection->get('gst_percentage');
            $rateItemDefinition->tds_percentage = $collection->get('tds_percentage');
            $rateItemDefinition->other_taxes = $collection->get('other_taxes');
            $rateItemDefinition->due_days = $collection->get('due_days');
            $rateItemDefinition->is_active = $collection->get('active') ? $collection->get('active') : 0;
            $rateItemDefinition->hsn_sac_code = $collection->get('hsn-sac-code');
            $rateItemDefinition->coa_group = $collection->get('group_select');
            $rateItemDefinition->ledger_type = $collection->get('individual_ledger');
            $rateItemDefinition->prefix = $collection->get('prefix');
            $rateItemDefinition->company_shortname = 'cmp';
            $rateItemDefinition->project_shortname = 'pjct';
            $rateItemDefinition->financial_year = $collection->get('financial_year');
            $rateItemDefinition->next_number = $collection->get('next_number');
            $rateItemDefinition->save();
            return true;
        } catch (\Throwable $th) {
            dd($th);
            info($th);
            return false;
        }
    }
}
