<?php

namespace App\Actions\MallSoftware\UnitDefinitions;

use App\UnitDefinition;
use Illuminate\Support\Collection;

class UnitDefinitionStoreAction
{
    public function execute(Collection $collection)
    {
        try {
            $data = new UnitDefinition();
            $data->unit_name = $collection->get('unit_name');
            $data->project_id = $collection->get('project');
            $data->block_id = $collection->get('blocks');
            $data->type_id = $collection->get('type');
            $data->floor_id = $collection->get('floor');
            $data->prefix = $collection->get('prefix');
            $data->suffix = $collection->get('suffix');
            $data->start_number = $collection->get('start_number');
            $data->number_units = $collection->get('number_units');
            $data->save();
            return true;
        } catch (\Throwable $th) {
            info($th);
            return false;
        }
    }
}
