<?php

namespace App\Actions\MallSoftware\UnitDefinitions;

use App\UnitDefinition;
use Illuminate\Support\Collection;

class UnitDefinitionUpdateAction
{
    public function execute(Collection $collection, UnitDefinition $unitDefinition)
    {
        try {
            $unitDefinition->unit_name = $collection->get('unit_name');
            $unitDefinition->project_id = $collection->get('project');
            $unitDefinition->blocks_id = $collection->get('blocks');
            $unitDefinition->type_id = $collection->get('type');
            $unitDefinition->floor_id = $collection->get('floor');
            $unitDefinition->prefix = $collection->get('prefix');
            $unitDefinition->suffix = $collection->get('suffix');
            $unitDefinition->start_number = $collection->get('start_number');
            $unitDefinition->number_units = $collection->get('number_units');
            $unitDefinition->save();
            return true;
        } catch (\Throwable $th) {
            info($th);
            return false;
        }
    }
}
