<?php

namespace App\Actions\ProjectUnit;

use App\Helpers\ActivityLog;
use App\PriceList;
use Illuminate\Support\Collection;

class CreateUnitAction
{
    public function execute(Collection $collection)
    {
        try {
            $priceList = new PriceList();
            $priceList->project_id = $collection->get('project_id');
            $priceList->floor = $collection->get('floor');
            $priceList->ap_no = $collection->get('ap_no');
            $priceList->sba_area = $collection->get('sba_area');
            $priceList->rate_per_sqft = $collection->get('rate_per_sqft');
            $priceList->sale_value = $collection->get('sale_value');
            $priceList->monthly_rental = $collection->get('monthly_rental');
            $priceList->type = $collection->get('type');
            if ($collection->has('layour_plan')) {
                $priceList->layour_plan = $collection->get('layour_plan')->store('project_units', 'uploads');
            }
            $priceList->save();
            $activity_subject = auth()->user()->name . ' added new project unit with id ' . $priceList->id;
            ActivityLog::addToLog($activity_subject, 'leads');

            return true;
        } catch (\Throwable $th) {
            info($th);
            return false;
        }
    }
}
