<?php

namespace App\Actions\ProjectUnit;

use App\Helpers\ActivityLog;
use App\PriceList;
use Illuminate\Support\Collection;

class UpdateUnitAction
{
    public function execute(Collection $collection)
    {
        try {
            $price_list = PriceList::find($collection->get('id'));

            $price_list->project_id = $collection->get('project_id');
            $price_list->floor = $collection->get('floor');
            $price_list->ap_no = $collection->get('ap_no');
            $price_list->sba_area = $collection->get('sba_area');
            $price_list->rate_per_sqft = $collection->get('rate_per_sqft');
            $price_list->sale_value = $collection->get('sale_value');
            $price_list->monthly_rental = $collection->get('monthly_rental');
            $price_list->type = $collection->get('type');
            $price_list->booking_status_id = $collection->get('booking_status_id');
            if ($collection->has('layour_plan')) {
                $price_list->layour_plan = $collection->get('layour_plan')->store('project_units', 'uploads');
            }
            $price_list->save();
            $activity_subject = auth()->user()->name . ' updated project unit with id ' . $price_list->id;
            ActivityLog::addToLog($activity_subject, 'leads');

            return true;
        } catch (\Throwable $th) {
            info($th);
            return false;
        }

        
    }
}
