<?php

namespace App\Actions\Projects;

use App\Note;
use App\PreferredProject;
use App\Helpers\ActivityLog;
use App\PreferredProjectImage;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class CreateProjectAction
{
    public function execute(Collection $collection)
    {


        DB::beginTransaction();


        try {

            $project = new PreferredProject();

            $project->project_type = $collection->get('project_type');
            $project->project_name = $collection->get('project_name');
            $project->company = $collection->get('company');
            $project->rera_no = $collection->get('rera_no');
            // $project->contact_person = $collection->get('contact_person_name');
            // $project->contact_person_number = $collection->get('contact_person_number');
            $project->agreement_percentage = $collection->get('agreement_percentage');
            // $project->email = $collection->get('email');
            $project->description = $collection->get('description');
            $project->location = $collection->get('location');
            $project->location_map = $collection->get('location_map');
            $project->video_link = $collection->get('video_link');
            $project->status = $collection->get('status');
            $project->visibility = $collection->get('visibility');



            $project->project_code = $collection->get('project_code');


            if ($collection->get('start_date')) {

                $project->start_date = date('Y-m-d', strtotime($collection->get('start_date')));
            }

            if ($collection->get('end_date')) {
                $project->end_date = date('Y-m-d', strtotime($collection->get('end_date')));
            }

            if ($collection->has('total_shares')) {
                $project->total_shares = $collection->get('total_shares');
            }

            if ($collection->has('min_shares')) {
                $project->min_shares = $collection->get('min_shares');
            }
            if ($collection->has('share_amount')) {
                $project->share_amount = $collection->get('share_amount');
            }

            if ($collection->has('administration_cost')) {
                $project->administration_cost = $collection->get('administration_cost');
            }

            if ($collection->has('share_return')) {
                $project->share_return = $collection->get('share_return');
            }

            if ($collection->has('ebrochure')) {
                $project->ebrochure = $collection->get('ebrochure')->store('ebrochure', 'uploads');
            }


            if ($collection->has('mobile_brochure')) {
                $project->mobile_brochure = $collection->get('mobile_brochure')->store('mobile_brochures', 'uploads');
            }


            if ($collection->has('progress_report')) {
                $project->progress_report = $collection->get('progress_report')->store('project_documents', 'uploads');
            }

            if ($collection->has('home_page')) {
                $project->home_page_image = $collection->get('home_page')->store('project_documents', 'uploads');
            }

            if ($collection->has('project_logo')) {
                $project->project_logo = $collection->get('project_logo')->store('project_images', 'uploads');
            }


            if ($project->save()) {


                if ($collection->has('photos')) {
                    $photos = $collection->has('photos') ? $collection->get('photos') : [];

                    if (is_array($photos) && count($photos) > 0) {

                        foreach ($photos as $key => $img) {
                            $projectImage = new PreferredProjectImage();
                            $projectImage->file = $img->store('photos', 'uploads');
                            $projectImage->preferred_project_id = $project->id;
                            $projectImage->save();
                        }
                    }
                }
            }


            $activity_subject = auth()->user()->name . ' added new project with id ' . $project->id;
            ActivityLog::addToLog($activity_subject, 'leads');


            DB::commit();

            return true;
            //code...
        } catch (\Throwable $th) {
            info($th);

            DB::rollback();

            return false;
        }
    }
}
