<?php

namespace App\Actions\Projects;

use App\Note;
use App\PreferredProject;
use App\Helpers\ActivityLog;
use App\PreferredProjectImage;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class DocumentUpdateAction
{
    public function execute(Collection $collection)
    {


        try {

            $project_id = $collection->get('project_id');
            $project = PreferredProject::find($project_id);

            if ($collection->has('ebrochure')) {
                $project->ebrochure = $collection->get('file')->store('ebrochure', 'uploads');
            }
            if ($collection->has('term_sheet')) {
                $project->term_sheet = $collection->get('file')->store('term_sheets', 'uploads');
            }
            if ($collection->has('progress_report')) {
                $project->progress_report = $collection->get('file')->store('project_documents', 'uploads');
            }
            if ($collection->has('availability_chart')) {
                $project->availability_chart = $collection->get('file')->store('project_documents/availability_charts', 'uploads');
            }
            if ($collection->has('mou')) {
                $project->mou = $collection->get('file')->store('project_documents/mou', 'uploads');
            }
            if ($collection->has('sample_calculation')) {
                $project->sample_calculation = $collection->get('file')->store('project_documents/sample_calculations', 'uploads');
            }
            if ($collection->has('allotment_letter')) {
                $project->allotment_letter = $collection->get('file')->store('project_documents/allotment_letters', 'uploads');
            }
            if ($collection->has('home_page_image')) {
                $project->home_page_image = $collection->get('file')->store('project_documents', 'uploads');
            }
            if ($collection->has('project_logo')) {
                $project->project_logo = $collection->get('file')->store('project_images', 'uploads');
            }
            $project->save();
            return true;
        } catch (\Throwable $th) {
            info($th);
            return false;
        }
    }
}
