<?php

namespace App\Actions\Projects;

use App\Note;
use App\PreferredProject;
use App\Helpers\ActivityLog;
use App\PreferredProjectImage;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class UpdateProjectAction
{
    public function execute(Collection $collection)
    {


        DB::beginTransaction();


        try {
            $project = PreferredProject::find($collection->get('id'));

            $project->project_type = $collection->get('project_type');
            $project->project_name = $collection->get('project_name');
            $project->company = $collection->get('company');
            $project->project_name_as_per_rera = $collection->get('project_name_as_per_rera');
            $project->rera_no = $collection->get('rera_no');
            // $project->contact_person = $collection->get('contact_person_name');
            $project->agreement_percentage = $collection->get('agreement_percentage');
            // $project->contact_person_number = $collection->get('contact_person_number');
            $project->beneficiary_name =  $collection->get('beneficiary_name');
            $project->preveling_rate = $collection->get('preveling_rate');
            $project->bank_account =  $collection->get('bank_account');
            $project->bank_name =  $collection->get('bank_name');
            $project->ifsc_code =  $collection->get('ifsc_code');
            $project->branch =  $collection->get('branch');
            $project->pdf_color =  $collection->get('pdf_color');
            // $project->email = $collection->get('email');
            $project->description = $collection->get('description');
            $project->location = $collection->get('location');
            $project->location_map = $collection->get('location_map');
            $project->video_link = $collection->get('video_link');
            $project->status = $collection->get('status');
            $project->visibility = $collection->get('visibility');
            $project->project_mail_name = $collection->get('project_mail_name');
            $project->phone_no = $collection->get('phone_no');
            $project->designation = $collection->get('designation');
            $project->project_email = $collection->get('project_email');
            $project->project_password = $collection->get('project_password');
            $project->valid_till = $collection->get('valid_till');
            $project->terms_and_conditions = $collection->get('terms_and_conditions');


            //newly added
            $project->project_code = $collection->get('project_code');



            if ($collection->get('start_date')) {

                $project->start_date = date('Y-m-d', strtotime($collection->get('start_date')));
            }

            if ($collection->get('end_date')) {
                $project->end_date = date('Y-m-d', strtotime($collection->get('end_date')));
            }


            if ($collection->has('total_shares')) {
                $project->total_shares = $collection->get('total_shares');
            }

            if ($collection->has('min_shares')) {
                $project->min_shares = $collection->get('min_shares');
            }
            if ($collection->has('share_amount')) {
                $project->share_amount = $collection->get('share_amount');
            }

            if ($collection->has('administration_cost')) {
                $project->administration_cost = $collection->get('administration_cost');
            }

            if ($collection->has('share_return')) {
                $project->share_return = $collection->get('share_return');
            }

            if ($collection->has('ebrochure')) {
                $name = $collection->get('ebrochure');
                $originalName = $name->getClientOriginalName();
                $project->ebrochure = $collection->get('ebrochure')->storeAs('ebrochure',$originalName, 'uploads');
            }


            if ($collection->has('mobile_brochure')) {
                $name = $collection->get('mobile_brochure');
                $originalName = $name->getClientOriginalName();
                $project->mobile_brochure = $collection->get('mobile_brochure')->storeAs('mobile_brochures',$originalName, 'uploads');
            }
            if ($collection->has('term_sheet')) {
                $name = $collection->get('term_sheet');
                $originalName = $name->getClientOriginalName();
                $project->term_sheet = $collection->get('term_sheet')->storeAs('term_sheets',$originalName, 'uploads');
            }


            if ($collection->has('progress_report')) {
                $name = $collection->get('progress_report');
                $originalName = $name->getClientOriginalName();
                $project->progress_report = $collection->get('progress_report')->storeAs('project_documents',$originalName, 'uploads');
            }

            if ($collection->has('home_page')) {
                $name = $collection->get('home_page');
                $originalName = $name->getClientOriginalName();
                $project->home_page_image = $collection->get('home_page')->storeAs('project_documents',$originalName, 'uploads');
            }

            if ($collection->has('project_logo')) {
                $name = $collection->get('project_logo');
                $originalName = $name->getClientOriginalName();
                $project->project_logo = $collection->get('project_logo')->storeAs('project_images',$originalName, 'uploads');
            }

            if ($collection->has('availability_chart')) {
                $name = $collection->get('availability_chart');
                $originalName = $name->getClientOriginalName();
                $project->availability_chart = $collection->get('availability_chart')->storeAs('project_documents/availability_charts',$originalName, 'uploads');
            }

            if ($collection->has('sample_calculation')) {
                $name = $collection->get('sample_calculation');
                $originalName = $name->getClientOriginalName();
                $project->sample_calculation = $collection->get('sample_calculation')->storeAs('project_documents/sample_calculations',$originalName, 'uploads');
            }
            if ($collection->has('mou')) {
                $name = $collection->get('mou');
                $originalName = $name->getClientOriginalName();
                $project->mou = $collection->get('mou')->storeAs('project_documents/mou',$originalName, 'uploads');
            }

            if ($collection->has('allotment_letter')) {
                $name = $collection->get('allotment_letter');
                $originalName = $name->getClientOriginalName();
                $project->allotment_letter = $collection->get('allotment_letter')->storeAs('project_documents/allotment_letters',$originalName, 'uploads');
            }
            if ($collection->has('llp')) {
                $name = $collection->get('llp');
                $originalName = $name->getClientOriginalName();
                $project->llp = $collection->get('llp')->storeAs('project_documents/llp',$originalName, 'uploads');
            }
            if ($collection->has('sale_agreement')) {
                $name = $collection->get('sale_agreement');
                $originalName = $name->getClientOriginalName();
                $project->sale_agreement = $collection->get('sale_agreement')->storeAs('project_documents/sale_agreement',$originalName, 'uploads');
            }
            if ($collection->has('deed')) {
                $name = $collection->get('deed');
                $originalName = $name->getClientOriginalName();
                $project->deed = $collection->get('deed')->storeAs('project_documents/deed',$originalName, 'uploads');
            }
            if ($collection->has('floor_plan')) {
                $name = $collection->get('floor_plan');
                $originalName = $name->getClientOriginalName();
                $project->floor_plan = $collection->get('floor_plan')->storeAs('project_documents/floor_plan',$originalName, 'uploads');
            }
            if ($collection->has('rera_qr_code')) {
                $name = $collection->get('rera_qr_code');
                $originalName = $name->getClientOriginalName();
                $project->rera_qr_code = $collection->get('rera_qr_code')->storeAs('project_documents/rera_qr_code',$originalName, 'uploads');
            }


            if ($project->save()) {


                if ($collection->has('photos')) {
                    $photos = $collection->has('photos') ? $collection->get('photos') : [];

                    if (is_array($photos) && count($photos) > 0) {

                        foreach ($photos as $key => $img) {
                            $projectImage = new PreferredProjectImage();
                            $projectImage->file = $img->store('photos', 'uploads');
                            $projectImage->preferred_project_id = $project->id;
                            $projectImage->save();
                        }
                    }
                }
            }


            $activity_subject = auth()->user()->name . ' updated project with id ' . $project->id;
            ActivityLog::addToLog($activity_subject, 'crm');


            DB::commit();

            return true;
            //code...
        } catch (\Throwable $th) {
            info($th);
            DB::rollback();

            return false;
        }
    }
}
