<?php

namespace App\Actions\Registration;

use App\User;
use App\SalesQuarter;
use App\Helpers\ActivityLog;
use App\PreferredProject;
use App\Registration;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class CreateRegistrationAction
{
    public function execute(Collection $collection)
    {


        try {
            DB::beginTransaction();

            if ($collection->get('dob') != null) {

                $collection['dob'] = Carbon::parse($collection->get('dob'))->format('Y-m-d');
            }
            if ($collection->get('co_owner_dob') != null) {

                $collection['co_owner_dob'] = Carbon::parse($collection->get('co_owner_dob'))->format('Y-m-d');
            }
            $collection['created_by'] = auth()->user()->id;

            $registration =   Registration::create($collection->toArray());





            $project = PreferredProject::find($registration->project_id);
            if ($project->project_type == 3) {
                $pdf = \PDF::loadView('dashboard.ApplicationForm.application', [
                    'registration' => $registration,
                    'project' => $project,
                ]);
            } else {
                $pdf = \PDF::loadView('dashboard.registrationForm.registrationFormPDF', [
                    'registration' => $registration,
                ]);
            }

            $fileName = 'uploads/registrations/' . $registration->name_prefix . $registration->name . '_' . $registration->id . '.pdf';
            $pdf->save($fileName);
            $registration->file = $fileName;
            $registration->save();

            DB::commit();
            return true;
        } catch (\Throwable $th) {
            info($th);
            DB::rollback();
            return false;
        }
    }
}
