<?php

namespace App\Actions\Users;

use App\User;
use App\Helpers\ActivityLog;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;

class UpdatePasswordAction
{
    public function execute(Collection $collection)
    {


        try {

            $user = User::find(auth()->user()->id)->update(['password' => Hash::make($collection->get('new_password'))]);

            // $user = User::find($collection->get('user_id'));

            // if ($collection->get('new_password')) {
            //     $user->password = Hash::make($collection->get('new_password'));
            // }

            if ($user) {

                $activity_subject = auth()->user()->name . ' changed password';
                ActivityLog::addToLog($activity_subject, 'leads');
                return true;
            }
        } catch (\Throwable $th) {
            //throw $th;
            info($th);
            return false;
        }
    }
}
