<?php

namespace App\Actions\Users;

use App\User;
use App\Helpers\ActivityLog;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;

class UpdateUserProfileAction
{
    public function execute(Collection $collection)
    {

        try {
            $user = User::find($collection->get('user_id'));

            $user->name = $collection->get('name');

            $user->phone_code = $collection->get('phone_code');
            $user->mobile = $collection->get('mobile');
            $user->designation = $collection->get('designation');




            $user->email = $collection->get('email');
            $user->email_password = $collection->get('gmail_password');



            $currentImage = $user->image;

            if ($collection->has('image')) {
                Storage::disk('uploads')->delete($currentImage);

                $user->image = $collection->get('image')->store('users', 'uploads');
            }


            if ($user->save()) {

                $activity_subject = auth()->user()->name . ' updated profile';
                ActivityLog::addToLog($activity_subject, 'leads');
                return true;
            }
        } catch (\Throwable $th) {
            //throw $th;
            info($th);
            return false;
        }
    }
}
