<?php


namespace App;
use Request;
use App\ActivityLog as ActivityLogModel;


class ActivityLogHelper
{


    public static function addToLog($subject, $id = NULL,$type=NULL,$activity=NULL)
    {
		$log = [];
		date_default_timezone_set('Asia/Kolkata'); 
		$c_time =  date("Y-m-d H:i:s");
		if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
			$ip_address = $_SERVER['HTTP_CLIENT_IP'];
		}
		//whether ip is from proxy
		elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			$ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
		}
		//whether ip is from remote address
		else {
			$ip_address = $_SERVER['REMOTE_ADDR'];
		}

    	$log['description'] = $subject;
		$log['activity'] = $activity;
    	$log['url'] = Request::fullUrl();
    	//$log['ip_address'] = Request::ip();
    	$log['ip_address'] = $ip_address;
    	$log['activity_at'] = $c_time;
		$log['user_id'] = auth()->check() ? auth()->user()->id : 1;
		// if($type=='login'){
		// 	$log['activity_type'] = 'login';
		// }
        $log['activity_id'] = $id;
        $log['activity_type'] = $type;
    	ActivityLogModel::create($log);
    }


    // public static function activityLogLists()
    // {
    // 	return ActivityLogModel::latest('activity_at')->get();
    // }


}