<?php

namespace App\Api\Http\Controllers\Api\V1\Auth;

use App\Api\Http\Controllers\Controller;
use App\Api\Http\Requests\LoginRequest;
use App\Api\Http\Requests\RegisterRequest;
use App\Role;
use App\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{

    public function register(RegisterRequest $request)
    {
        $user = new User();
        $user->name = $request->name;
        $user->branch_id = 1;
        $user->username = $request->username;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->mobile = $request->mobile;
        $user->reporting_to = 1;
        if ($user->save()) {
            $role_obj = Role::find(8);
            $user->roles()->attach($role_obj);
            return response()->json([
                'message' => 'User Registered successfully',
                'data' => [
                    'username' => $user->username,
                    'userId' => $user->id,
                    'role' => $user->roles ? $user->roles[0]['name'] : '',
                ],
            ]);
        }
        return response()->json([
            'message' => 'something went wrong',
            'data' => [],
        ]);
    }

    public function login(LoginRequest $request): JsonResponse
    {

        if (!Auth::attempt($request->only(['username', 'password']))) {
            return response()->json([
                'message' => 'Credentials do not match!',
            ], 401);
        }

        /** @var User $authUser */
        $authUser = auth()->user();

        if ($authUser->status == 0) {
            return response()->json([
                'message' => 'Credentials do not match!',
            ], 401);
        }

        if ($request->filled('push_token') && $request->filled('device_type')) {
            $authUser->push_token = $request->push_token;
            $authUser->device_type = $request->device_type;
            $authUser->device_name = $request->device_name;
            $authUser->device_id = $request->device_id;
            $authUser->save();
        }

        return response()->json([
            'message' => 'Logged in successfully',
            'data' => [
                'username' => $authUser->username,
                'userId' => $authUser->id,
                'role' => $authUser->roles ? $authUser->roles[0]['name'] : '',
                'token' => $authUser->createToken('hi-leads')->plainTextToken,
            ],
        ]);
    }



    public function logout(): JsonResponse
    {
        /** @var User $authUser */
        $authUser = Auth::user();
        $authUser->tokens()->delete();

        $authUser->pushTokens()->delete();

        return response()->json([
            'message' => 'Logged out',
        ]);
    }
    public function registerStatus(): JsonResponse
    {
        $status = 0;

        return response()->json([
            'message' => 'register button status',
            'data' => [
                'status' => $status,
            ],
        ]);
    }

    public function loginWithoutPassword(Request $request): JsonResponse
    {
        $credentials = $request->only(['username']);
        $user = User::where($credentials)->first();

        if (!$user) {
            return response()->json([
                'status' => false,
                'message' => 'Credentials do not match!',
            ], 401);
        }

  
        if ($user->status == 0) {
            return response()->json([
                'status' => false,
                'message' => 'Credentials do not match!',
            ], 401);
        }
        $token = $user->createToken('hi-leads')->plainTextToken;

        if ($request->filled('push_token') && $request->filled('device_type')) {

            $user->push_token = $request->push_token;
            $user->device_type = $request->device_type;
            $user->device_name = $request->device_name;
            $user->device_id = $request->device_id;
            $user->save();
        }

        return response()->json([
            'message' => 'Logged in successfully',
            'data' => [
                'username' => $user->username,
                'userId' => $user->id,
                'role' => $user->roles ? $user->roles[0]['name'] : '',
                'token' => $token,
            ],
        ]);
    }

    public function changePassword(Request $request)
    {
        $request->validate([
            'old_password' => 'required',
            'new_password' => 'required|confirmed',
        ]);

        $user = auth()->user();

        if(!Hash::check($request->old_password, $user->password)){
            return response()->json([
                'status' => "false",
                'message' => "Old Password does not match!"
            ]);
        }
        
        if(Hash::check($request->new_password, $user->password)){
            return response()->json([
                'status' => false,
                'message' => "New password must be different from Current password"
            ]);
        }

        User::whereId($user->id)->update([
            'password' => Hash::make($request->new_password)
        ]);

        return response()->json([
            'status' => "true",
            'message' => "Password Changed Successfully"
        ]);
    }
}
