<?php

namespace App\Api\Http\Controllers\Api\V1\DailyActivity;

use app\Api\Http\Requests\DailyActivity\DailyActivityRequest;
use App\Api\Http\Resources\TaskType\TaskTypeCollection;
use App\Api\Http\Resources\User\UserCollection;
use App\Api\Http\Resources\User\UserResource;
use App\CreateTask;
use App\DailyActivityCalculation;
use App\Helpers\ActivityLog;
use App\Http\Controllers\Controller;
use App\Http\Requests\Dashboard\DailyActivity\DailyActivityStoreRequest;
use App\Lead;
use App\Location;
use App\PreferredProject;
use App\Task;
use App\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;

class DailyActivityController extends Controller
{
    public function DailyActivitylist()
    {
        $taskTypes = CreateTask::where('status', 1)->where('daily_activity', 1)->get();
        return $this->success(
            'Task Types!',
            new TaskTypeCollection($taskTypes)
        );
    }

    public function store(DailyActivityStoreRequest $request): JsonResponse
    {
        try {
            $user = auth()->user();

            if ($request->lead_id == null) {

                if ($request->mobile) {
                    $lead = Lead::where('mobile', 'LIKE', $request->mobile)
                        ->where(function ($query) use ($user) {
                            $query->where('created_by', $user->id)
                                ->orWhere('attended_by', $user->id);
                        })
                        ->first();

                    if (!$lead) {
                        $lead = new Lead();
                        $lead->enquirer_name = $request->name;
                        $lead->mobile = $request->mobile;
                        $lead->phone_code = $request->phone_code;
                        $lead->source = $request->source;
                        $lead->lead_date = date('Y-m-d');
                        $lead->attended_by =  $user->id;
                        $lead->created_by = $user->id;
                        $lead->updated_by = $user->id;
                        $lead->is_attended = 1;
                        $check = false;
                        $check_mobile_task = false;
                        $fifteenDays = now()->subDays(15);
                        $threeMonthBefore = now()->subMonths(3);

                        $mobile =  $request->mobile;
                        $phoneCode = $request->phone_code;

                        if (!empty($mobile)) {

                            $check = Lead::where('mobile', $mobile)->get()->last();

                            if (!$check) {
                                $mbb = $phoneCode  . $mobile;
                                $check = Lead::where('mobile', $mbb)->get()->last();
                                if (!$check) {
                                    $check = Lead::where('mobile', $mobile)->get()->last();

                                    if (!$check) {

                                        $n = 10;

                                        if (strlen($mobile) == 9) {

                                            $n = 9;
                                        }

                                        if (strlen($mobile) == 8) {

                                            $n = 8;
                                        }

                                        $start = strlen($mobile) - $n;
                                        $last_str = substr($mobile, $start);
                                        if ($start >= 0) {
                                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                                        }
                                    }
                                }
                            }
                        }


                        if ($check) {
                            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
                        }

                        if ($check && $check->created_at >= $threeMonthBefore) {
                            $lead->duplicate_entry = 'yes';
                            $lead->sales_head_approval = 0;
                        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

                            $lead->duplicate_entry = 'yes';
                            $lead->sales_head_approval = 0;
                        }
                        $lead->save();
                        $leadId = $lead->id;
                    } else {
                        $leadId = $lead->id;
                    }
                }
            } else {
                $leadId = $request->lead_id;
            }

            if (auth()->user()->hasRole('team-leader')) {
                $user_id = $request->user_id;
            } else {
                $user_id = $user->id;
            }


            $taskData = [
                'lead_id' =>  $leadId,
                'create_task_id' => $request->create_task_id,
                'lead_category' => $request->lead_category,
                'schedule_date' => date('Y-m-d'),
                'project' => $request->project,
                'lead_stage' => $request->lead_stage,
                'created_by' => $user_id,
                'task_completed_status' => 1,
                'latitude' => $request->latitude,
                'longitude' => $request->longitude,
                'remarks' => $request->remarks,
                'followup_by' => $user_id,
                'place_address' => $request->place_address,

            ];

            if ($request->has('image')) {
                $taskData['image'] = $request->file('image')->store('Task', 'uploads');
            }

            $task = Task::create($taskData);
            if ($task) {
                $project = PreferredProject::find($request->project);
                $type = Null;
                if ($project) {
                    $type = $project->project_type;
                }
                if ($request->location_id != 15 && $request->location_id != 16 && $request->location_id != null) {
                    $locat = Location::find($request->location_id);
                    $location = $locat->name;
                } else {
                    $location = $request->location_name ?? '';
                }
                $lead = Lead::find($task->lead_id);
                $lead->lead_stage_id = $request->lead_stage ? $request->lead_stage : NULL;
                $lead->lead_category = $request->lead_category ? $request->lead_category : NULL;
                $lead->preferred_project = $request->project ?  $request->project : NULL;
                $lead->latitude = $request->latitude ? $request->latitude : NULL;
                $lead->longitude = $request->longitude ? $request->longitude : NULL;
                $lead->city = $request->city ? $request->city : NULL;
                $lead->country = $request->country ? $request->country : NULL;
                $lead->residential_status = $request->residential_status ? $request->residential_status : NULL;
                $lead->project_type = $type;
                $lead->location = $location;
                $lead->place_address = $request->place_address ? $request->place_address : NULL;
                $lead->location_id = $request->location_id;
                $lead->is_attended = 1;
                $lead->phone_code = $request->phone_code;
                $lead->save();
                $activitySubject = $user->name . ' added a new daily task with ID : ' . $task->id;
                ActivityLog::addToLog($activitySubject, 'leads');

                return $this->success(
                    'Daily Task has been added successfully.',
                );
            }
        } catch (\Throwable $th) {
            info($th);
            return $this->error(
                'Something went wrong,Please try again.',
            );
        }
    }

    public function Report()
    {
        $user = auth()->user();
        $currentDate = date('Y-m-d');
        $id = $user->id;

        $tasks = Task::where('created_by', $user->id)
        ->where('task_completed_status', 1)
        ->where('schedule_date', $currentDate)
        ->whereIn('create_task_id', [2, 3, 10, 11, 12, 13,14,15,16,17,18,19])
        ->where(function ($query){
            $query->whereIn('create_task_id', [2,3,13,14,12,19])
                ->where('team_leader_approved', 1);
        })
        ->orWhere(function ($query) use ($id, $currentDate) {
            $query->where('created_by',$id)
                ->whereIn('create_task_id', [10,11,15,16,17,18])
                ->whereDate('schedule_date', $currentDate);
        })
        ->select('tasks.*', DB::raw('(SELECT MAX(point) FROM daily_activity_calculations WHERE create_task_id = tasks.create_task_id) as max_point'))
        ->get()
        ->groupBy('lead_id');

        $calculations = DailyActivityCalculation::get();
        $leadPoint = DailyActivityCalculation::find(1)->point ?? 0;

        $tasks->transform(function ($leadTasks) {
            return $leadTasks->sortByDesc('max_point')->first();
        });

        $leadsToSkip = $tasks->pluck('lead_id');

        // $newLeadCount = Lead::where('created_by', $id)
        //     ->where('lead_date', $currentDate)
        //     ->where('duplicate_entry', 'no')
        //     ->whereNotIn('id', $leadsToSkip)
        //     ->count();
        // $leadCalculation = number_format($newLeadCount * $leadPoint, 3);
        $siteVist = $tasks->where('create_task_id', 2)->count();
        $sitePoint = $calculations->where('create_task_id', 2)->first()->point;
        $totalSitepoint = number_format($siteVist * $sitePoint, 3);

        $officeVist = $tasks->where('create_task_id', 13)->count();
        $OfficePoint = $calculations->where('create_task_id', 13)->first()->point;
        $totalOfficePoint = number_format($officeVist * $OfficePoint, 3);
        $directMarketing = $tasks->where('create_task_id', 11)->count();

        $directMarketingPoint = $calculations->where('create_task_id', 11)->first()->point;
        $totalDirectMarketingPoint = number_format($directMarketing * $directMarketingPoint, 3);
        $mallCounter = $tasks->where('create_task_id', 10)->count();
        $mallCounterPoint = $calculations->where('create_task_id', 10)->first()->point;
        $totalMallCounterPoint =  number_format($mallCounter * $mallCounterPoint, 3);

        $appointments = $tasks->where('create_task_id', 3)->count();
        $appointmentPoint = $calculations->where('create_task_id', 3)->first()->point;
        $totalAppointmentPoint = number_format($appointments * $appointmentPoint, 3);

        $virtual = $tasks->where('create_task_id', 12)->count();
        $virtualPoint = $calculations->where('create_task_id', 12)->first()->point;
        $totalVirtualPoint = number_format($virtual * $virtualPoint, 3);

        // $followup = $tasks->where('create_task_id', 19)->where('duration', '>=', 120)->count();
        $followuptasks = $tasks->where('create_task_id',19);
        $countWithNullImageAndDuration = $followuptasks->filter(function ($task) {
            return $task->image == null && $task->duration >= 120;
        })->count();
       
        $countWithNotNullImageAndTeamLeaderApprove = $followuptasks->filter(function ($task) {
            return $task->image != null && $task->team_leader_approved == 1;
        })->count();
        $followup = $countWithNullImageAndDuration + $countWithNotNullImageAndTeamLeaderApprove;
        $followupCount = $calculations->where('create_task_id', 19)->first()->point;
        $followupPoint = number_format($followup * $followupCount, 3);


        $fresh = $tasks->where('create_task_id', 15)->count();
        $freshRuno = $tasks->where('create_task_id', 17)->where('duration', '>=', 30)->count();
        $freshCall =  $fresh + $freshRuno;
        $freshCallPoint = $calculations->where('create_task_id', 15)->first()->point;
        $totalFreshCallPoint = number_format($freshCall  * $freshCallPoint, 3);

        $freshNri = $tasks->where('create_task_id', 16)->count();
        $freshNriRuno = $tasks->where('create_task_id', 18)->where('duration', '>=', 30)->count();
        $freshCallNriPoint = $calculations->where('create_task_id', 16)->first()->point;
        $freshCallNri = $freshNri + $freshNriRuno;
        $totalFreshCallNriPoint = number_format($freshCallNri * $freshCallNriPoint, 3);



        $connectHeads = $tasks->where('create_task_id', 14)->count();
        $connectHeadsPoint = $calculations->where('create_task_id', 14)->first()->point;
        $totalconnectHeadsPoint = number_format($connectHeads * $connectHeadsPoint, 3);
        $data = [
            // [
            //     'activity_type' => 'New lead',
            //     'point' => $leadCalculation,
            //     'count' => strval($newLeadCount),
            // ],
            [
                'activity_type' => 'Fresh Call (Resident)',
                'point' => $totalFreshCallPoint ?? '0.0',
                'count' => strval($freshCall),
            ],
            [
                'activity_type' => 'Fresh Call (NRI)',
                'point' =>  $totalFreshCallNriPoint ?? '0.0',
                'count' => strval($freshCallNri),
            ],
            [
                'activity_type' => 'Follow Up Call',
                'point' => $followupPoint ?? '0.0',
                'count'=> strval($followup)
            ],
            [
                'activity_type' => 'Appointments',
                'point' => $totalAppointmentPoint ?? '0.0',
                'count' => strval($appointments),
            ],
            [
                'activity_type' => 'Site Visit',
                'point' =>  $totalSitepoint ?? '0.0',
                'count' => strval($siteVist)
            ],
            [
                'activity_type' => 'Office Visit',
                'point' => $totalOfficePoint ?? '0.0',
                'count' => strval($officeVist)
            ],
            [
                'activity_type' => 'Direct Marketing',
                'point' => $totalDirectMarketingPoint ?? '0.0',
                'count' => strval($directMarketing)
            ],
            [
                'activity_type' => 'Mall Counter',
                'point' => $totalMallCounterPoint ?? '0.0',
                'count' => strval($mallCounter)
            ],
            [
                'activity_type' => 'Virtual Meeting',
                'point' => $totalVirtualPoint ?? '0.0',
                'count' => strval($virtual)
            ],
            [
                'activity_type' => 'Call Connected to Heads',
                'point' => $totalconnectHeadsPoint ?? '0.0',
                'count' => strval($connectHeads)
            ]
           

        ];

        $totalPoints = 0.0;

        foreach ($data as $item) {
            $totalPoints += $item['point'];
        }

        $colorCode = '#37D086';

        return [
            'status' => 'true',
            'message' => 'Daily Task Report',
            'current_date' => $currentDate,
            'total_points' => number_format($totalPoints, 3),
            'color_code' => $colorCode,
            'data' => $data,
        ];
    }

    public function usersList()
    {
        $authUser = auth()->user();

        $users = User::where('reporting_to', $authUser->id)
            ->where('status', 1)
            ->get();
        $users->prepend($authUser);

        $usersData = $users->map(function ($user) {
            return [
                'id' => $user->id,
                'name' => $user->name,
            ];
        });

        return [
            'status' => true,
            'message' => "Users List",
            'data' => $usersData,

        ];
    }

    public function storeUnattended(DailyActivityStoreRequest $request): JsonResponse
    {
        try {
            $user = auth()->user();

            if ($request->lead_id == null) {

                if ($request->mobile) {
                    $lead = Lead::where('mobile', 'LIKE', $request->mobile)
                        ->where(function ($query) use ($user) {
                            $query->where('created_by', $user->id)
                                ->orWhere('attended_by', $user->id);
                        })
                        ->first();

                    if (!$lead) {
                        $lead = new Lead();
                        $lead->enquirer_name = $request->name;
                        $lead->mobile = $request->mobile;
                        $lead->phone_code = $request->phone_code;
                        $lead->source = $request->source;
                        $lead->lead_date = date('Y-m-d');
                        $lead->attended_by =  $user->id;
                        $lead->created_by = $user->id;
                        $lead->updated_by = $user->id;
                        $lead->is_attended = 1;
                        $check = false;
                        $check_mobile_task = false;
                        $fifteenDays = now()->subDays(15);
                        $threeMonthBefore = now()->subMonths(3);

                        $mobile =  $request->mobile;
                        $phoneCode = $request->phone_code;

                        if (!empty($mobile)) {

                            $check = Lead::where('mobile', $mobile)->get()->last();

                            if (!$check) {
                                $mbb = $phoneCode  . $mobile;
                                $check = Lead::where('mobile', $mbb)->get()->last();
                                if (!$check) {
                                    $check = Lead::where('mobile', $mobile)->get()->last();

                                    if (!$check) {

                                        $n = 10;

                                        if (strlen($mobile) == 9) {

                                            $n = 9;
                                        }

                                        if (strlen($mobile) == 8) {

                                            $n = 8;
                                        }

                                        $start = strlen($mobile) - $n;
                                        $last_str = substr($mobile, $start);
                                        if ($start >= 0) {
                                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                                        }
                                    }
                                }
                            }
                        }


                        if ($check) {
                            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
                        }

                        if ($check && $check->created_at >= $threeMonthBefore) {
                            $lead->duplicate_entry = 'yes';
                            $lead->sales_head_approval = 0;
                        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

                            $lead->duplicate_entry = 'yes';
                            $lead->sales_head_approval = 0;
                        }
                        $lead->save();
                        $leadId = $lead->id;
                    } else {
                        $leadId = $lead->id;
                    }
                }
            } else {
                $leadId = $request->lead_id;
            }

                $user_id = $user->id;


            $taskData = [
                'lead_id' =>  $leadId,
                'create_task_id' => $request->create_task_id,
                'lead_category' => $request->lead_category,
                'schedule_date' => date('Y-m-d'),
                'project' => $request->project,
                'lead_stage' => $request->lead_stage,
                'created_by' => $user_id,
                'task_completed_status' => 1,
                'latitude' => $request->latitude,
                'longitude' => $request->longitude,
                'remarks' => $request->remarks,
                'followup_by' => $user_id,
                'place_address' => $request->place_address,

            ];

            if ($request->has('image')) {
                $taskData['image'] = $request->file('image')->store('Task', 'uploads');
            }

            $task = Task::create($taskData);
            if ($task) {
                $project = PreferredProject::find($request->project);
                $type = Null;
                if ($project) {
                    $type = $project->project_type;
                }
                if ($request->location_id != 15 && $request->location_id != 16 && $request->location_id != null) {
                    $locat = Location::find($request->location_id);
                    $location = $locat->name;
                } else {
                    $location = $request->location_name ?? '';
                }
                $lead = Lead::find($task->lead_id);
                $lead->lead_stage_id = $request->lead_stage ? $request->lead_stage : NULL;
                $lead->lead_category = $request->lead_category ? $request->lead_category : NULL;
                $lead->preferred_project = $request->project ?  $request->project : NULL;
                $lead->latitude = $request->latitude ? $request->latitude : NULL;
                $lead->longitude = $request->longitude ? $request->longitude : NULL;
                $lead->city = $request->city ? $request->city : NULL;
                $lead->country = $request->country ? $request->country : NULL;
                $lead->residential_status = $request->residential_status ? $request->residential_status : NULL;
                $lead->project_type = $type;
                $lead->location = $location;
                $lead->place_address = $request->place_address ? $request->place_address : NULL;
                $lead->location_id = $request->location_id;
                $lead->is_attended = 1;
                $lead->phone_code = $request->phone_code;
                $lead->save();
                $activitySubject = $user->name . ' added a new daily task with ID : ' . $task->id;
                ActivityLog::addToLog($activitySubject, 'leads');

                return $this->success(
                    'Daily Task has been added successfully.',
                );
            }
        } catch (\Throwable $th) {
            info($th);
            return $this->error(
                'Something went wrong,Please try again.',
            );
        }
    }
}
