<?php

namespace App\Api\Http\Controllers\Api\V1\DailyActivity;

use App\DailyActivityCalculation;
use App\DailyWorkPlan;
use App\Http\Controllers\Controller;

class DailyCalculationController extends Controller
{
    public function index()
    {
        $dailyCalculations = DailyActivityCalculation::where('status', 1)->get();
        $user = auth()->user();
        $data = [];

        foreach ($dailyCalculations as $calculation) {
            $data[] = [
                'id' => strval($calculation->id),
                'create_task_id' => strval($calculation->create_task_id),
                'name' => strval($calculation->name),
                'points' => strval($calculation->point),
            ];
        }
        $work_plan_status = 0;
        $workPlan = DailyWorkPlan::where('user_id', $user->id)->where('date', now()->format('Y-m-d'))->first();
        if ($workPlan) {
            $work_plan_status = 1;
        }

        return [
            'status' => 'true',
            'message' => 'Daily Activity Calculations',
            'data' => $data,
            'work_plan_status' => strval($work_plan_status),
        ];
    }
}
