<?php

namespace App\Api\Http\Controllers\Api\V1\DailyActivity;

use App\Http\Controllers\Controller;
use App\Notifications\TeamLeaderApprovedNotification;
use App\Notifications\TeamLeaderRejectedNotification;
use App\Task;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DailyTaskActivityController extends Controller
{

    public function index()
    {
        $user = Auth::user();
        $userRoles = auth()
            ->user()
            ->userRoles();
        $currentDate = now()->format('Y-m-d');

        $tasks = Task::with(['getLead'])
            ->where('task_completed_status', 1)
            ->where('team_leader_approved', 0)
            ->whereDate('schedule_date', $currentDate);

        if (auth()->user()->hasRole('team-leader')) {
            $userIds = $user->getAllReportingUsersIds();
            $data = $tasks
                ->whereIn('create_task_id', [2, 3, 13, 12, 19])
                ->whereIn('created_by', $userIds);
        } elseif (auth()->user()->hasRole('sales-head') && auth()->user()->act_as_leader == 0 ) {
            $branchUserIds = User::where('branch_id', auth()->user()->branch_id)->get()->pluck('id');
            $data = $tasks->whereIn('created_by', $branchUserIds)->where('create_task_id', 14);
        }
        elseif(auth()->user()->hasRole('sales-head') && auth()->user()->act_as_leader == 1){
            $branchUserIds = User::where('branch_id', auth()->user()->branch_id)->get()->pluck('id');
            $data = $tasks->whereIn('created_by', $branchUserIds)->whereIn('create_task_id', [2, 3, 13, 12, 14, 19]);

        } else {
            $data = $tasks->whereIn('create_task_id', [2, 3, 13, 12, 14, 19]);
        }

        $data = $data->get();
        $responseData = [];
        foreach ($data as $task) {
            $responseData[] = [
                'id' => $task->id ?? '',
                'lead_id' => $task->lead_id ?? '',
                'lead_name' => $task->getLead->enquirer_name ?? '',
                'project' => $task->getProject->project_name ?? '',
                'activity_type' => $task->getTaskType->name ?? '',
                'date' => $task->schedule_date ?? '',
                'sales_person' => $task->getCreatedBy->name ?? '',
                'image' => $task->image ? asset('uploads/' . $task->image) : '',
                'remark' => $task->remarks ?? '',
                'mobile' => $task->getLead->mobile ?? '',
                'phone_code' => $task->getLead->phone_code ?? '',
                'lead_category' => $task->getLeadCategory ? $task->getLeadCategory->name : '',
                'lead_stage' => $task->getLeadStage ? $task->getLeadStage->name : '',
                'status' => $task->task_completed_status ?? '',
                'duration' => $task->duration ?? '',
                'runo_created_at' => $task->runo_created_at ?? '',
                'runo_date' => $formattedDate ?? '',
                'resident' =>  $task->getLead->residential_status ?? '',
                'location' => $task->getLead->location ?? '',
                'lead_status' =>  $task->getLeadCategory->name ?? '',
                'lead_source' => $task->getLead->getSource->name ?? '',
                'place' =>  $task->getLead->place_address ?? '',


            ];
        }

        return [
            'status' => 'true',
            'message' => 'Daily Task Activity List',
            'data' => $responseData,
        ];
    }

    public function Approve(Request $request)
    {
        $task = Task::find($request->id);
        $task->team_leader_approved = 1;
        $task->save();

        $userId = $task->followup_by;
        $user = User::find($userId);
        
        if ($user->push_token != '') {
            $user->notify(new TeamLeaderApprovedNotification($user, $task->getTaskType->name));
        }
        
        return [
            'message' => 'Daily Task Activity Approved ',
        ];
    }

    public function Reject(Request $request)
    {
        $task = Task::find($request->id);
        $task->team_leader_approved = 2;

        $userId = $task->followup_by;
        $user = User::find($userId);

        if ($user->push_token != '') {
            $user->notify(new TeamLeaderRejectedNotification($user, $task->getTaskType->name));
        }

        $task->save();

        return [
            'message' => 'Daily Task Activity rejected',
        ];
    }

    public function delete(Task $task)
    {
        $task->delete();

        return response()->json([
            'status' => true,
            'message' => "Tasks Deleted Successfully"
        ]);
    }
}
