<?php

namespace App\Api\Http\Controllers\Api\V1\Event;

use App\Api\Http\Requests\Event\EventCalenderRequest;
use App\Http\Controllers\Controller;
use App\Api\Http\Resources\Tasks\TaskCollection;
use App\Task;
use App\User;
use Illuminate\Http\Request;

class EventCalenderController extends Controller
{
    public function eventCalender(EventCalenderRequest $request)
    {
        $year = $request->year;
        $month = $request->month;


        $todaysTasks = Task::whereYear('schedule_date', '=', $year)
        ->whereMonth('schedule_date', '=', $month)
        ->whereIn('create_task_id', [2, 3, 13, 12])
        ->orderBy('task_completed_status')
        ->orderBy('schedule_date', 'asc')
        ->with([
            'getTaskType',
            'getFollowupBy',
            'getProject',
            'getLeadCategory',
            'getLeadStage',
            'getFollowupStatus',
            'getSiteVisitStatus',
            'getBudget',
            'getCreatedBy'
        ]);


        if (!auth()->user()->hasRole('admin') && !auth()->user()->hasRole('super-admin')) {

            $all_reporting_users_id_array = \Auth::user()->getAllReportingUsersIds();
            array_push($all_reporting_users_id_array, \Auth::user()->id);

            $todaysTasks = $todaysTasks->whereIn('tasks.created_by', $all_reporting_users_id_array)
            ->orWhere('followup_by', auth()->user()->id);

            $typefollowTask = $todaysTasks
                ->orderBy('task_completed_status')
                ->orderBy('schedule_date', 'asc')
                ->whereYear('schedule_date', '=', $year)
                ->whereIn('create_task_id', [2, 3, 13, 12])
                ->whereMonth('schedule_date', '=', $month)->get();
        } elseif (auth()->user()->hasRole('sales-head')) {
            $all_reporting_users_id_array = User::whereHas('roles', function ($q) {
                $q->where('role_id', 8);
            })->where('branch_id', auth()->user()->branch_id)->get()->pluck('id');

            $todaysTasks = $todaysTasks->whereIn('tasks.created_by', $all_reporting_users_id_array);

        } else {
            $typefollowTask = $todaysTasks->get();
        }

        return $this->success(
            'Events',
            new TaskCollection($typefollowTask)
        );
    }
}
