<?php

namespace App\Api\Http\Controllers\Api\V1\Followup;

use App\Api\Http\Resources\FollowUpType\FollowUpTypeCollection;
use App\FollowupType;
use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class FollowUpTypeController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $followUpTypes = FollowupType::where('status', 1)->get();

        return $this->success(
            'Follow up types',
            new FollowUpTypeCollection($followUpTypes)
        );
    }
}
