<?php

namespace App\Api\Http\Controllers\Api\V1\Lead;

use App\Api\Http\Requests\Lead\CallLeadListRequest;
use App\Api\Http\Requests\Lead\LeadAllocationRequest;
use App\Api\Http\Resources\Leads\LeadCollection;
use App\Api\Http\Resources\User\UserCollection;
use App\Http\Controllers\Controller;
use App\Lead;
use App\Helpers\ActivityLog;
use App\Notification;
use App\Notifications\AllocationNotification;
use App\User;
use Illuminate\Database\Eloquent\Builder;
use Spatie\QueryBuilder\AllowedFilter;
use Spatie\QueryBuilder\QueryBuilder;
use Illuminate\Http\Request;

class LeadAllocationController extends Controller
{
    public function leadAllocation(LeadAllocationRequest $request)
    {
        $authUser = auth()->user();
        $userRoles = $authUser->userRoles();

        $allocateTo = $request->allocate_to;
        $leadIds = $request->lead_id;
        foreach ($leadIds as $id) {
            $lead = Lead::find($id);
            $lead->attended_by = $allocateTo;
            // if($userRoles->contains('slug', 'team-leader')){
            //     $lead->is_attended = 0;
            // }else{
            //     $lead->is_attended = 1;
            // }
            if (\Auth::user()->id == $allocateTo) { // allocate to myself
                $lead->show_in_salesperson_actions = 0;
            }
            if (empty($lead->unique_id)) {
                $uId = 'HiLEAD/' . date('Y') . '/' .  $lead->id;
                $lead->unique_id = $uId;
            }
            $lead->allocation_date =date('Y-m-d H:i:s');
            if ($lead->save()) {
                $activity_subject = auth()->user()->name . ' Allocated Lead from  api to salesperson id ' . $allocateTo . ' with id : ' . $lead->id;
                ActivityLog::addToLog($activity_subject, 'leads');
                $user = User::find($allocateTo);
                if ($user->push_token != '') {
                    $user->notify(new AllocationNotification($user));
                }
                $source = $lead->getSource ? $lead->getSource->name :"";
                $message = "You have been assigned a new lead.Plese take a moment to review the details:".$lead->enquirer_name.'-'.$source;
                $notification = new Notification();
                $notification->user_id = auth()->user()->id;
                $notification->title = 'New Lead';
                $notification->message = $message;
                $notification->type = 'leads';
                $notification->save();
            }
        }

        
        return $this->success(
            'Lead allocated successfully!',
        );
    }

    public function allocationUser()
    {
        $userRoles = auth()
            ->user()
            ->userRoles();
        $all_reporting_users_id_array = [];

        if ($userRoles->contains('slug', 'team-leader')) {
            $authUser = auth()->user();
            $all_reporting_users_id_array = $authUser->getAllReportingUsersIds();
            array_push($all_reporting_users_id_array, $authUser->id);
        }
        elseif($userRoles->contains('slug', 'sales-head')) {
            $authUser = auth()->user();
            $all_reporting_users_id_array =  User::where('branch_id', $authUser->branch_id)->get()->pluck('id')->toArray();
            array_push($all_reporting_users_id_array, $authUser->id);
        }
        $users = User::whereIn('id', $all_reporting_users_id_array)->get();
        return (new UserCollection($users))->additional(['message' => 'Users list!']);
    }

    public function allocationlist()
    {
        $authUser = auth()->user();
        $userRoles = $authUser->userRoles();
        
        $all_reporting_users_id_array = [];
        if (!$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin')) {
            $all_reporting_users_id_array = $authUser->getAllReportingUsersIds();
            array_push($all_reporting_users_id_array, $authUser->id);
        }
        
            $leads = QueryBuilder::for(Lead::class)
            ->with([
                'getLeadStage',
                'getUnit',
                'getAttendedBy',
                'getSource',
                'getProjectType',
                'getPreferredProject',
                'getPreferredProject.getProjectType',
                'getBudget',
                'getLeadCategory',
            ])
            ->where('is_ceo_verified', 1)
            ->where('is_attended', 0)
            ->where('attended_by', $authUser->id)
            ->where('sale_status', '!=', 'yes')
            ->where('show_in_salesperson_actions', 1)
            ->whereHas('getSource', function ($query){
                $query->where('status', 0);
            })
            ->allowedFilters([
                AllowedFilter::exact('id'),
                AllowedFilter::exact('source', 'getSource.id'),
                AllowedFilter::exact('project', 'getPreferredProject.id'),
                AllowedFilter::scope('starts_between'),

            ])
            ->defaultSort('-created_at')
            ->jsonPaginate()
            ->appends(request()->query());
            
        return (new LeadCollection($leads))->additional(['message' => 'Allocation Leads list!']);
    }

    public function leadAddList(CallLeadListRequest $request)
    {
        $leadIds = $request->lead_id;
        foreach ($leadIds as $id) {
            $lead = Lead::find($id);
            $lead->call_lead_list = 1;
            $lead->save();
        }

        return $this->success(
            'Lead Added To Call List Successfully!',
        );
    }
}
