<?php

namespace App\Api\Http\Controllers\Api\V1\Lead;

use App\Api\Http\Resources\Leads\LeadCollection;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\JsonResponse;
use Mail;
use App\Api\Http\Requests\Lead\LeadRequest;
use App\Api\Http\Requests\Lead\WhatsappLeadRequest;
use App\Api\Http\Requests\Lead\WhatsappmLeadRequest;
use App\Api\Http\Resources\Leads\LeadResource;
use App\Http\Controllers\Controller;
use App\Lead;
use App\LeadAlternativeProject;
use Illuminate\Http\Request;
use App\Helpers\ActivityLog;
use App\LeadBank;
use App\Location;
use App\Task;
use App\User;
use Illuminate\Support\Facades\DB;
use Spatie\QueryBuilder\AllowedFilter;
use Spatie\QueryBuilder\QueryBuilder;

class LeadController extends Controller
{
    public function index(Request $request): LeadCollection
    {
        $userRoles = auth()
            ->user()
            ->userRoles();
        $all_reporting_users_id_array = [];
        $authUser = auth()->user();
        if (!$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin') && !$userRoles->contains('slug', 'head-sales')) { //Except superadmin and admin
            $all_reporting_users_id_array = $authUser->getAllReportingUsersIds();
            array_push($all_reporting_users_id_array, $authUser->id);
        }elseif ($userRoles->contains('slug', 'sales-head')) {
            $all_reporting_users_id_array = User::whereHas('roles', function ($q) {
                $q->where('role_id', 8);
            })->where('branch_id', auth()->user()->branch_id)
            ->where('status',1)
            ->pluck('id')
            ->toArray();
        }
        // $userRoles = auth()
        //     ->user()
        //     ->userRoles();

        // $authUser = auth()->user();
        // if (!$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin') && !$userRoles->contains('slug', 'sales-head')) { //Except superadmin and admin
        //     $all_reporting_users_id_array = $authUser->getAllReportingUsersIds();
        //     array_push($all_reporting_users_id_array, $authUser->id);
        // }
        $leads = QueryBuilder::for(Lead::class)
            ->with([
                'getLeadStage',
                'getUnit',
                'getAttendedBy',
                'getSource',
                'getProjectType',
                'getPreferredProject',
                'getPreferredProject.getProjectType',
                'getBudget',
                'getLeadCategory',
                'getCallLog'
            ])

            ->where(function ($query) {
                $query->whereNotIn('lead_stage_id', [6, 7, 8])->orWhereNull('lead_stage_id');
            })
            ->when($userRoles->contains('slug', 'executive'), function ($q) {
                $q->where('is_attended', 1);
            })
            ->when(!$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin') && !$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'sales-head'), function ($q) use ($all_reporting_users_id_array) {
                $q->whereIn('attended_by', $all_reporting_users_id_array);
            })
            ->where('sale_status', 'no')
            ->defaultSort('-created_at')

            ->allowedFilters([
                AllowedFilter::callback('is_today', function (Builder $query, $value) {
                    $query->whereDate('created_at', today());
                }),
                AllowedFilter::callback('project_type', function (Builder $query, $value) {
                    if ($value == 0) {
                        $query->whereNull('project_type');
                    } else {
                        $query->where('project_type', $value);
                    }
                }),
                
                AllowedFilter::exact('id'),
                // AllowedFilter::exact('project_type', 'getProjectType.id'),
                AllowedFilter::exact('source', 'getSource.id'),
                AllowedFilter::exact('project', 'getPreferredProject.id'),
                AllowedFilter::scope('starts_between'),

            ])
            ->jsonPaginate()
            ->appends(request()->query());

        return (new LeadCollection($leads))->additional(['message' => 'Leads list!']);
    }

    public function store(LeadRequest $request): JsonResponse
    {

        DB::beginTransaction();
        try {

            /** @var \App\User $user */
            $user = auth()->user();

            $mobile = $request->mobile;
            $email = $request->email;
            $phoneCode = $request->phone_code;
            $altProject = $request->input('alt_project', []);
            $attendedBy = $request->input('attended_by');


            $isAttended = 0;
            if (auth()->user()->hasRole('executive')) {
                $isAttended = 1;
            }

            if ($request->location_id != 15 && $request->location_id != 16) {
                $locat = Location::find($request->location_id);
                $location = $locat->name;
            } else {
                $location = $request->location_name;
            }

            $lead = new Lead();
            $lead->enquirer_name = $request->enquirer_name;
            $lead->email = $email;
            $lead->phone_code = $phoneCode;
            $lead->mobile = $mobile;
            $lead->alt_mobile = $request->alternative_mobile;
            $lead->source = $request->source;
            $lead->project_type = $request->project_type;
            $lead->preferred_project = $request->preferred_project;
            $lead->budget = $request->input('budget');
            $lead->gender = $request->gender;
            $lead->profession = $request->profession;
            $lead->location = $location;
            $lead->location_id = $request->location_id;
            $lead->whatsapp_no = $request->whatsapp_no;
            $lead->dob = $request->dob;
            $lead->address = $request->address;
            $lead->city = $request->city;
            $lead->pin = $request->pin;
            $lead->lead_date = date('Y-m-d');
            $lead->remarks = $request->remarks;
            $lead->created_by = $user->id;
            $lead->updated_by = $user->id;
            $lead->is_attended = $isAttended;
            // $lead = Lead::create([
            //     'enquirer_name' => $request->enquirer_name,
            //     'email' => $email,
            //     'phone_code' => $phoneCode,
            //     'mobile' => $mobile,
            //     'alt_mobile' => $request->alternative_mobile,
            //     'source' => $request->source,
            //     'project_type' => $request->project_type,
            //     'preferred_project' => $request->preferred_project,
            //     'budget' => $request->input('budget'),
            //     'gender' => $request->gender,
            //     'profession' => $request->profession,
            //     'location' => $location,
            //     'location_id' => $request->location_id,
            //     'whatsapp_no' => $request->whatsapp_no,
            //     'dob' => $request->dob,
            //     'address' => $request->address,
            //     'city' => $request->city,
            //     'pin' => $request->pin,
            //     'lead_date' => date('Y-m-d'),
            //     'remarks' => $request->remarks,
            //     'created_by' => $user->id,
            //     'updated_by' => $user->id,
            //     'is_attended' => $isAttended,
            // ]);

            if ($user->hasRole('lead-bank')) {
                $lead->is_ceo_verified = 0;
            }

            $lead->attended_by = $user->id;

            if (
                $user->hasRole('super-admin') ||
                $user->hasRole('admin')
            ) {
                $lead->attended_by = null;
                if (!empty($attendedBy)) {
                    $lead->attended_by = $attendedBy;
                }
            } elseif (empty($user->reporting_to)) {
                $lead->attended_by = null; // user with no role and reporting to
            }
            if ($request->duplicate_status == 1) {
                $lead->duplicate_request_remarks = $request->remarks;
                $lead->duplicate_request_by = auth()->user()->id;
                $lead->duplicate_request_at = now();
            }

            $check = false;
            $check_email = false;
            $check_mobile_task = false;
            $check_email_task = false;
            $fifteenDays = now()->subDays(15);
            $threeMonthBefore = now()->subMonths(3);



            if (!empty($mobile)) {
                // $check = Lead::where('phone_code', $phone_code)->where('mobile', $mobile)->first();

                $check = Lead::where('mobile', $mobile)->get()->last();

                // $task = Task::where('lead_id', $check->id)->get()->last();
                if (!$check) {
                    $mbb = $phoneCode  . $mobile;
                    $check = Lead::where('mobile', $mbb)->get()->last();
                    if (!$check) {
                        $check = Lead::where('phone_code', $phoneCode)->where('mobile', $mobile)->get()->last();

                        if (!$check) {

                            $n = 10;

                            if (strlen($mobile) == 9) {

                                $n = 9;
                            }

                            if (strlen($mobile) == 8) {

                                $n = 8;
                            }

                            $start = strlen($mobile) - $n;
                            $last_str = substr($mobile, $start);
                            if ($start >= 0) {
                                $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                            }
                        }
                    }
                }
            }
            if (!empty($email)) {
                $check_email = Lead::where('email', $email)->get()->last();
            }

            if ($check) {
                $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
            }
            if ($check_email) {
                $check_email_task = Task::where('lead_id', $check_email->id)->get()->last();
            }

            if ($check && $check->created_at >= $threeMonthBefore) {
                $lead->duplicate_entry = 'yes';
                $lead->sales_head_approval = 0;
            } elseif ($check_email && $check_email->created_at >= $threeMonthBefore) {


                $lead->duplicate_entry = 'yes';
                $lead->sales_head_approval = 0;
            } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

                $lead->duplicate_entry = 'yes';
                $lead->sales_head_approval = 0;
            } elseif ($check_email_task && $check_email_task->created_at >= $fifteenDays) {

                $lead->duplicate_entry = 'yes';
                $lead->sales_head_approval = 0;
            }

            $lead->save();

            if (!empty($lead->id)) {
                $leadId = $lead->id;
                $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
                $lead->unique_id = $uId;
                $lead->save();

                LeadAlternativeProject::where('lead_id', $leadId)->delete();

                if (is_array($altProject) && count($altProject) > 0) {
                    foreach ($altProject as $ap) {
                        $alternativeProject = new LeadAlternativeProject();
                        $alternativeProject->lead_id = $leadId;
                        $alternativeProject->preferred_project_id = $ap;
                        $alternativeProject->save();
                    }
                }

                // log Activity
                $activitySubject = $user->name . ' added a lead ' . $lead->enquirer_name . ' with ID : ' . $lead->id;
                ActivityLog::addToLog($activitySubject, 'leads');

                // if ($check || $checkEmail) { // send mail
                //     if ($user->hasRole('team-leader') || \Auth::user()->hasRole('user')) {
                //         //sent mail to sales head for approval
                //         $salesHeadDet = '';
                //         if ($user->hasRole('team-leader')) {
                //             $salesHeadDet = $user->getReportingTo ?? '';
                //         } elseif ($user->hasRole('user')) {
                //             $teamLeaderDet = $user->getReportingTo ?? '';
                //             if ($teamLeaderDet) {
                //                 $iddd = $teamLeaderDet->id;
                //                 $detidd = \App\User::find($iddd);
                //                 if ($detidd) {
                //                     $salesHeadDet = $detidd->getReportingTo ?? '';
                //                 }
                //             }
                //         }

                //         if ($salesHeadDet) {
                //             $dupByEmail = $lead->getdupByEmail();
                //             $dupByMobile = $lead->getdupByMobile();
                //             $details = [
                //                 'sales_head_name' => $salesHeadDet->name,
                //                 'sales_head_email' => $salesHeadDet->email,
                //                 'added_by' => $user->name,
                //                 'lead_details' => $lead,
                //                 'dupByEmail' => $dupByEmail,
                //                 'dupByMobile' => $dupByMobile,
                //             ];
                //             $to = $salesHeadDet->email;

                //             if (\Mail::to($to)->send(new \App\Mail\SalesHeadApproval($details))) {
                //                 return response()->json(['status' => true, 'message' => 'Lead has been added successfully.']);
                //             }
                //         }
                //     }
                // }

                if(!$check){
                    $leadBankExists = LeadBank::where('phone_code', $phoneCode)->where('mobile', $mobile)->exists();
                
                    if (!$leadBankExists) {
                    $Lead_bank = new LeadBank();
                    $Lead_bank->enquirer_name = $request->enquirer_name;
                    $Lead_bank->email = $email;
                    $Lead_bank->phone_code = $phoneCode;
                    $Lead_bank->mobile = $mobile;
                    $Lead_bank->alt_mobile = $request->alternative_mobile;
                    $Lead_bank->source = $request->source;
                    $Lead_bank->project_type = $request->project_type;
                    $Lead_bank->preferred_project = $request->preferred_project;
                    $Lead_bank->budget = $request->input('budget');
                    $Lead_bank->gender = $request->gender;
                    $Lead_bank->profession = $request->profession;
                    $Lead_bank->location_id = $request->location_id;
                    $Lead_bank->whatsapp_no = $request->whatsapp_no;
                    $Lead_bank->dob = $request->dob;
                    $Lead_bank->address = $request->address;
                    $Lead_bank->city = $request->city;
                    $Lead_bank->lead_date = date('Y-m-d');
                    $Lead_bank->remarks = $request->remarks;
                    $Lead_bank->created_by = $user->id;
                    $Lead_bank->updated_by = $user->id;
                    $Lead_bank->attended_by = $user->id;
        
                    if ($user->hasRole('super-admin') ||
                        $user->hasRole('admin')) {
                        $Lead_bank->attended_by = null;
                        if (!empty($attendedBy)) {
                            $Lead_bank->attended_by = $attendedBy;
                        }
                    } elseif (empty($user->reporting_to)) {
                        $Lead_bank->attended_by = null;
                    }
                    $Lead_bank->save();
                }
            }

                DB::commit();

                return $this->success(
                    'Lead has been added successfully..',
                );
            }
        } catch (\Throwable $th) {
            info($th);
            DB::rollBack();
            return $this->error(
                'Failed to add Lead..',
            );
        }
    }

    public function WhatsappUnattendedLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->source = 72;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = null;
        $lead->created_by = 1;
        $lead->updated_by = 1;
        $lead->is_attended = 0;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 
        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;

        } 
     


        $lead->save();
        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function WhatsappLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = null;
        $lead->created_by = 1;
        $lead->updated_by = 1;
        $lead->is_attended = 0;
        $lead->project_type = 3;
        $lead->preferred_project = 26;
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function PromoLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 19;
        $lead->created_by = 19;
        $lead->updated_by = 19;
        $lead->is_attended = 1;
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function kannurPromoLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 57;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 7;
        $lead->created_by = 7;
        $lead->updated_by = 7;
        $lead->is_attended = 1;
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function aswinOmanLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 261;
        $lead->created_by = 261;
        $lead->updated_by = 261;
        $lead->is_attended = 1;
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function najeebLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 40;
        $lead->created_by = 40;
        $lead->updated_by = 40;
        $lead->is_attended = 1;


        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function sahadLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 92;
        $lead->created_by = 92;
        $lead->updated_by = 92;
        $lead->is_attended = 1;
        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function ShahanaLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 69;
        $lead->created_by = 69;
        $lead->updated_by = 69;
        $lead->is_attended = 1;
        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function SalimLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 25;
        $lead->created_by = 25;
        $lead->updated_by = 25;
        $lead->is_attended = 1;
        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function JannathulFarhanLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 153; //nesla id changed
        $lead->created_by = 153;
        $lead->updated_by = 153;
        $lead->is_attended = 1;
        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function FaheemLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 163;
        $lead->created_by = 163;
        $lead->updated_by = 163;
        $lead->is_attended = 1;
        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function yusraLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 71;
        $lead->created_by = 71;
        $lead->updated_by = 71;
        $lead->is_attended = 1;
        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function sairaBanuLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 107;
        $lead->created_by = 107;
        $lead->updated_by = 107;
        $lead->is_attended = 1;
        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function navasLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 73;
        $lead->created_by = 73;
        $lead->updated_by = 73;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function AthulAryanLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 67;
        $lead->created_by = 67;
        $lead->updated_by = 67;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function AswinULeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 84;
        $lead->created_by = 84;
        $lead->updated_by = 84;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function ShajahanLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 89;
        $lead->created_by = 89;
        $lead->updated_by = 89;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function BurayyanLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 68;
        $lead->created_by = 68;
        $lead->updated_by = 68;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function NajiLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 254;
        $lead->created_by = 254;
        $lead->updated_by = 254;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function JasimLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 264;
        $lead->created_by = 264;
        $lead->updated_by = 264;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function MahsoomLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 177;
        $lead->created_by = 177;
        $lead->updated_by = 177;
        $lead->is_attended = 1;
        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } 
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function SalvaLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 104;
        $lead->created_by = 104;
        $lead->updated_by = 104;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }


    public function JufsadLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 179;
        $lead->created_by = 179;
        $lead->updated_by = 179;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AnurajLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 146;
        $lead->created_by = 146;
        $lead->updated_by = 146;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function MuhsinaLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 234;
        $lead->created_by = 234;
        $lead->updated_by = 234;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    
    public function RushaidLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 201;
        $lead->created_by = 201;
        $lead->updated_by = 201;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AjinasLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 205;
        $lead->created_by = 205;
        $lead->updated_by = 205;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function ShareefLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 212;
        $lead->created_by = 212;
        $lead->updated_by = 212;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function HiderLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 258;
        $lead->created_by = 258;
        $lead->updated_by = 258;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function ShantheepLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 97;
        $lead->created_by = 97;
        $lead->updated_by = 97;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function SirajLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 143;
        $lead->created_by = 143;
        $lead->updated_by = 143;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function SinanLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 232;
        $lead->created_by = 232;
        $lead->updated_by = 232;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function MahirLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 263;
        $lead->created_by = 263;
        $lead->updated_by = 263;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function MoheenudheenLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 140;
        $lead->created_by = 140;
        $lead->updated_by = 140;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function ThejilsanLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 141;
        $lead->created_by = 141;
        $lead->updated_by = 141;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function FasalRahmanLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 169;
        $lead->created_by = 169;
        $lead->updated_by = 169;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }


    public function show(Lead $lead): JsonResponse
    {
        return $this->success(
            'Lead fetched!',
            new LeadResource($lead->loadMissing(
                'getLeadStage',
                'getUnit',
                'getAttendedBy',
                'getSource',
                'getProjectType',
                'getPreferredProject.getProjectType',
                'getBudget',
                'getLeadCategory',
            ))
        );
    }

    public function update(LeadRequest $request, Lead $lead): JsonResponse
    {
        /** @var \App\User $user */
        $user = auth()->user();

        $altProject = $request->alt_project;
        $allocateTo = $request->allocate_to;
        $updatedBy = $user->id;

        $lead->enquirer_name = $request->input('enquirer_name', $lead->enquirer_name);
        $lead->email = $request->input('email', $lead->email);
        $lead->phone_code = $request->input('phone_code', $lead->phone_code);
        $lead->mobile = $request->input('mobile', $lead->mobile);
        $lead->alt_mobile = $request->input('alt_mobile', $lead->alt_mobile);
        $lead->source = $request->input('source', $lead->source);
        $lead->project_type = $request->input('project_type', $lead->project_type);
        $lead->preferred_project = $request->input('preferred_project', $lead->preferred_project);
        $lead->budget = $request->input('budget', $lead->budget);
        $lead->whatsapp_no = $request->input('whatsapp_no', $lead->whatsapp_no);
        $lead->lead_stage_id = $request->input('lead_stage', $lead->lead_stage_id);

        if ($request->lead_stage === 7) {
            $lead->sale_status = "yes";
        }
        if ($request->location_id != 15 && $request->location_id != 16) {
            $locat = Location::find($request->location_id);
            $location = $locat->name;
        } else {
            $location = $request->location_name;
        }

        $lead->lead_category = $request->input('lead_category', $lead->lead_category);
        $lead->lead_percentage = $request->input('lead_percentage', $lead->lead_percentage);
        $lead->residential_status = $request->input('residential_status', $lead->residential_status);
        $lead->gender = $request->input('gender', $lead->gender);
        $lead->dob = $request->dob ? date('Y-m-d', strtotime($request->dob)) : $lead->dob;
        $lead->age = $request->input('age', $lead->age);
        $lead->profession = $request->input('profession', $lead->profession);
        $lead->location = $location;
        $lead->location_id = $request->input('location_id', $lead->location_id);
        $lead->address = $request->input('address', $lead->address);
        $lead->city = $request->input('city', $lead->city);
        $lead->pin = $request->input('pin', $lead->pin);
        $lead->remarks = $request->input('remarks', $lead->remarks);
        $lead->updated_by = $updatedBy;
        $lead->profession = $request->input('profession', $lead->profession);
        $lead->profession = $request->input('profession', $lead->profession);
        $lead->country = $request->input('country', $lead->country);
        $lead->state = $request->input('state', $lead->state);
        $lead->village = $request->input('village', $lead->village);
        $lead->desom = $request->input('desom', $lead->desom);
        $lead->post = $request->input('post', $lead->post);
        $lead->taluk = $request->input('taluk', $lead->taluk);

        if ($request->lead_stage === 6 || $request->lead_stage === 8) {
            $lead->lost_lead_approval = 0;
        }

        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;

            $attendBy = $lead->attended_by;
            if (!empty($allocateTo)) {
                $lead->attended_by = $allocateTo;
                if ($user->id === $allocateTo) { // allocate to myself
                    $lead->show_in_salesperson_actions = 0;
                }

                if (empty($lead->unique_id)) {
                    $uId = 'ONEA/' . date('Y') . '/' . $lead->id;
                    $lead->unique_id = $uId;
                }

                if ($attendBy !== $allocateTo) {
                    $lead->allocation_date = date('Y-m-d');
                }

                $lead->save();
            }

            LeadAlternativeProject::where('lead_id', $leadId)->delete();

            if (is_array($altProject) && count($altProject) > 0) {
                foreach ($altProject as $ap) {
                    $leadAlternativeProject = new LeadAlternativeProject();
                    $leadAlternativeProject->lead_id = $leadId;
                    $leadAlternativeProject->preferred_project_id = $ap;
                    $leadAlternativeProject->save();
                }
            }

            // log Activity
            $activitySubject = $user->name . ' edited a lead ' . $lead->enquirer_name . ' with ID : ' . $lead->id;
            ActivityLog::addToLog($activitySubject, 'leads');

            return $this->success(
                'Lead Details successfully updated..',
            );
        }

        return $this->success(
            'Failed to update lead..',
        );
    }

    public function search()
    {
        $userRoles = auth()
            ->user()
            ->userRoles();
        $all_reporting_users_id_array = [];
        $authUser = auth()->user();
        if (!$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin') && !$userRoles->contains('slug', 'sales-head')) { //Except superadmin and admin
            $all_reporting_users_id_array = $authUser->getAllReportingUsersIds();
            array_push($all_reporting_users_id_array, $authUser->id);
        }



        $leads = QueryBuilder::for(Lead::class)
            ->with([
                'getLeadStage',
                'getUnit',
                'getAttendedBy',
                'getSource',
                'getProjectType',
                'getPreferredProject',
                'getPreferredProject.getProjectType',
                'getBudget',
                'getLeadCategory',
            ])

            ->where(function ($query) {
                $query->whereNotIn('lead_stage_id', [6, 7, 8])->orWhereNull('lead_stage_id');
            })
            ->when($userRoles->contains('slug', 'executive'), function ($q) {
                $q->where('is_attended', 1);
            })
            ->when(!$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin') && !$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'sales-head'), function ($q) use ($all_reporting_users_id_array) {
                $q->whereIn('attended_by', $all_reporting_users_id_array);
            })


            ->where('sale_status', 'no')
            ->allowedFilters([
                AllowedFilter::scope('lead_search')
            ])

            ->defaultSort('-created_at')
            ->jsonPaginate()
            ->appends(request()->query());

        return (new LeadCollection($leads))->additional(['message' => 'Leads list!']);
    }
}
