<?php

namespace App\Api\Http\Controllers\Api\V1\Lead;
use App\Http\Controllers\Controller;
use App\Lead;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LeadDuplicateController extends Controller
{
    public function leadMobileDuplicate(Request $request)
    {
        $phoneCode = $request->phone_code;
        $mobile = $request->mobile;
        $mbb = $phoneCode  . $mobile;
        $check = false;
        $threeMonthBefore = now()->subMonths(3);
        if (!empty($mobile)) {
            $check = Lead::where('mobile', $mobile)->get()->last();
          
           
            if (!$check) {
                $mbb = $phoneCode  . $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                
                if (!$check) {
                    $check = Lead::where('phone_code', $phoneCode)->where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                            
                        }
                    }
                }
            }
           
        }
        if($check){
           
          if($check->attended_by == auth()->user()->id){
            $status = 2;
             $message = 'This is your existing lead, please manage from the same';
            return response()->json([
                'message' => $message,
                'data' => [
                    'status' => $status,
                    'last_attended'=>$name ?? '',
                ],
            ]);
            
          }
          elseif($check->created_by == auth()->user()->id){
          
            $status = 2;
            $message = 'This is your existing lead, please manage from the same';
            return response()->json([
                'message' => $message,
                'data' => [
                    'status' => $status,
                    'last_attended'=>$name ?? '',
                ],
            ]);
           
          }

        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $status = 1;
            $user_id = $check->attended_by;
            $user = User::find($user_id);
            $name =$user->name;
        $message = 'Entry made duplicate ,please contact sales support';
        }
        else{
            $status = 0;
            $name = '';
            $message = '';
        }
      
        return response()->json([
            'message' => $message,
            'data' => [
                'status' => $status,
                'last_attended'=>$name ?? '',
            ],
        ]);
    }

    public function leadEmailDuplicate(Request $request){

        $email = $request->email;
        $check = false;
        $threeMonthBefore = now()->subMonths(3);
        if (!empty($email)) {
            $check_email = Lead::where('email', $email)->get()->last();
            $dupemail = Lead::where('email', $email)->where(function ($query) {
                $query->where('created_by', '=', auth()->user()->id)
                      ->orWhere('attended_by', '=', auth()->user()->id);
            })->get();
        }
      
        if(count($dupemail) > 0){
            
            $status = 2;
            $message = "This is your existing lead, please manage from the same";
            return response()->json([
                'message' => $message,
                'data' => [
                    'status' => $status,
                    'last_attended'=>$name ?? '',
                ],
            ]);
        }
        if ($check_email && $check_email->created_at >= $threeMonthBefore) {
            $status = 1;
            $user_id = $check_email->attended_by;
            $user = User::find($user_id);
            $name =$user->name;
            $message = "Entry made duplicate ,please contact sales support";
            return response()->json([
                'message' => $message,
                'data' => [
                    'status' => $status,
                    'last_attended'=>$name ?? '',
                ],
            ]);
            
        }
        else{
            $status = 0;
            $name ='';
        }
        return response()->json([
            'message' => 'Duplicate button status',
            'data' => [
                'status' => $status,
                'last_attended'=>$name ?? '',
            ],
        ]);

    }
}

