<?php

namespace App\Api\Http\Controllers\Api\V1\Lead;

use App\Api\Http\Resources\Leads\LeadCollection;
use App\Api\Http\Resources\Leads\LeadResource;
use App\Http\Controllers\Controller;
use App\Lead;
use Illuminate\Http\Request;
use Spatie\QueryBuilder\QueryBuilder;
use Illuminate\Http\JsonResponse;


class LeadsListController extends Controller
{
    public function index(Request $request): JsonResponse
    {
        $leads = QueryBuilder::for(Lead::class)
            ->where('status', 1)
            ->jsonPaginate();

        return $this->success(
            'Leads fetched!',
            new LeadCollection($leads)
        );
    }
}
