<?php

namespace App\Api\Http\Controllers\Api\V1\Lead;

use App\Api\Http\Resources\Leads\LeadCollection;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\JsonResponse;
use Mail;
use App\Api\Http\Requests\Lead\LeadRequest;
use App\Api\Http\Requests\Lead\WhatsappLeadRequest;
use App\Api\Http\Requests\Lead\WhatsappmLeadRequest;
use App\Api\Http\Resources\Leads\LeadResource;
use App\Http\Controllers\Controller;
use App\Lead;
use App\LeadAlternativeProject;
use Illuminate\Http\Request;
use App\Helpers\ActivityLog;
use App\Location;
use App\Task;
use App\User;
use Illuminate\Support\Facades\DB;
use Spatie\QueryBuilder\AllowedFilter;
use Spatie\QueryBuilder\QueryBuilder;

class WhatsappLeadStoreController extends Controller
{
    public function SujinLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 81;
        $lead->created_by = 81;
        $lead->updated_by = 81;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AjinasLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 205;
        $lead->created_by = 205;
        $lead->updated_by = 205;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function NaslaLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 153;
        $lead->created_by = 153;
        $lead->updated_by = 153;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function BabeeshLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 96;
        $lead->created_by = 96;
        $lead->updated_by = 96;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );

    }

    public function ShihabudheenLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 235;
        $lead->created_by = 235;
        $lead->updated_by = 235;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AnjanaLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 245;
        $lead->created_by = 245;
        $lead->updated_by = 245;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function ShabinasLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 198;
        $lead->created_by = 198;
        $lead->updated_by = 198;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AfnasLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 288;
        $lead->created_by = 288;
        $lead->updated_by = 288;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function SunayanaLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 132;
        $lead->created_by = 132;
        $lead->updated_by = 132;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function AyishaHibaLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 156;
        $lead->created_by = 156;
        $lead->updated_by = 156;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }
    public function NijinLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 214;
        $lead->created_by = 214;
        $lead->updated_by = 214;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AjmalLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 275;
        $lead->created_by = 275;
        $lead->updated_by = 275;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function ThahaLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 12;
        $lead->created_by = 12;
        $lead->updated_by = 12;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function SidharthLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 272;
        $lead->created_by = 272;
        $lead->updated_by = 272;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AswinLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 17;
        $lead->created_by = 17;
        $lead->updated_by = 17;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function RazaqueLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 19;
        $lead->created_by = 19;
        $lead->updated_by = 19;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AfthabLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 23;
        $lead->created_by = 23;
        $lead->updated_by = 23;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function RaviKiranLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 57;
        $lead->created_by = 57;
        $lead->updated_by = 57;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function MuhammedLalLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 75;
        $lead->created_by = 75;
        $lead->updated_by = 75;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AkheelLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 237;
        $lead->created_by = 237;
        $lead->updated_by = 237;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AbhiramiLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 176;
        $lead->created_by = 176;
        $lead->updated_by = 176;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function BarjasLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 108;
        $lead->created_by = 108;
        $lead->updated_by = 108;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function NeethuLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 121;
        $lead->created_by = 121;
        $lead->updated_by = 121;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function AjithLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 159;
        $lead->created_by = 159;
        $lead->updated_by = 159;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function NishadLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 78;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 70;
        $lead->created_by = 70;
        $lead->updated_by = 70;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }

    public function JasirLeadStore(WhatsappLeadRequest $request)
    {
        $lead = new Lead();
        $lead->enquirer_name = $request->name;
        $lead->mobile = $request->mobile;
        $lead->phone_code = $request->phone_code;
        $lead->source = 48;
        $lead->lead_date = date('Y-m-d');
        $lead->attended_by = 109;
        $lead->created_by = 109;
        $lead->updated_by = 109;
        $lead->is_attended = 1;

        
        $check = false;
        $check_mobile_task = false;
        $fifteenDays = now()->subDays(15);
        $threeMonthBefore = now()->subMonths(3);

        $mobile =  $request->mobile;

        if (!empty($mobile)) {
        
            $check = Lead::where('mobile', $mobile)->get()->last();

            if (!$check) {
                $mbb =  $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
 

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
    
        if ($check && $check->created_at >= $threeMonthBefore) {
            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

            $lead->duplicate_entry = 'yes';
            $lead->sales_head_approval = 0;
        }  
        $lead->save();

        if (!empty($lead->id)) {
            $leadId = $lead->id;
            $uId = 'HiLEAD/' . date('Y') . '/' . $leadId;
            $lead->unique_id = $uId;
            $lead->save();
            return $this->success(
                'Lead has been added successfully..',
            );
        }
        return $this->error(
            'Failed to add Lead..',
        );
    }



}