<?php

namespace App\Api\Http\Controllers\Api\V1\Project;

use App\Api\Http\Requests\Project\PreferredProjectRequest;
use App\Api\Http\Resources\PreferredProject\PreferredProjectCollection;
use app\Api\Http\Resources\PreferredProject\PreferredProjectViewResource;
use App\Api\Http\Resources\ProjectView\ProjectViewResource;
use App\Http\Controllers\Controller;
use App\PreferredProject;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class PreferredProjectController extends Controller
{
    public function preferredProject(PreferredProjectRequest $request): JsonResponse
    {
        $project_type = $request->project_type;
        $preferredProjects = PreferredProject::where('project_type', $project_type)
            ->where('visibility', 'others')
            ->where('status', 1)
           
            ->get();
        return $this->success(
            'Preferred Projects!',
            new PreferredProjectCollection($preferredProjects)
        );
    }
    public function ExecutivePreferredProject(PreferredProjectRequest $request): JsonResponse
    {
        $project_type = $request->project_type;
        $preferredProjects = PreferredProject::where('project_type', $project_type)
            ->where('visibility', 'others')
            ->where('status', 1)
            ->where('user_side', 1)
            ->get();
        return $this->success(
            'Preferred Projects!',
            new PreferredProjectCollection($preferredProjects)
        );
    }
    public function getProjects(): JsonResponse
    {

        $preferredProjects = PreferredProject::where('visibility', 'others')
            ->where('status', 1)
            ->get();
        return $this->success(
            'Preferred Projects!',
            new PreferredProjectCollection($preferredProjects)
        );
    }
    public function view($id)
    {
        $project = PreferredProject::find($id);
        return $this->success(
            'Preferred Projects!',
            new ProjectViewResource($project)
        );
    }
}
