<?php

namespace App\Api\Http\Controllers\Api\V1\Task;

use App\Api\Http\Requests\Task\TaskActionRequest;
use App\Api\Http\Requests\Task\TaskRequest;
use App\Api\Http\Resources\Tasks\TaskCollection;
use App\Api\Http\Resources\Tasks\TaskResource;
use App\Http\Controllers\Controller;
use App\Task;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\JsonResponse;
use App\Helpers\ActivityLog;
use App\Lead;
use App\PreferredProject;
use App\User;
use Illuminate\Http\Request;
use Spatie\QueryBuilder\AllowedFilter;
use Spatie\QueryBuilder\QueryBuilder;

class TaskController extends Controller
{
    public function index(Request $request): TaskCollection
    {


        $all_reporting_users_id_array = [];
        $userRoles = auth()
            ->user()
            ->userRoles();
        $date = date('Y-m-d');

        $authUser = auth()->user();
        if (!$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin') && !$userRoles->contains('slug', 'head-sales')) { //Except superadmin and admin
            $all_reporting_users_id_array = $authUser->getAllReportingUsersIds();
            array_push($all_reporting_users_id_array, $authUser->id);
        }elseif ($userRoles->contains('slug', 'sales-head')) {
            $all_reporting_users_id_array = User::whereHas('roles', function ($q) {
                $q->where('role_id', 8);
            })->where('branch_id', auth()->user()->branch_id)
            ->where('status',1)
            ->pluck('id')
            ->toArray();
        }


        $tasks = QueryBuilder::for(Task::class)
            ->with([
                'getTaskType',
                'getFollowupBy',
                'getProject',
                'getLeadCategory',
                'getLeadStage',
                'getFollowupStatus',
                'getSiteVisitStatus',
                'getBudget',
                'getCreatedBy',
                'getLead'
            ])
            ->where(function ($query) use ($all_reporting_users_id_array) {
                $query->whereIn('followup_by', $all_reporting_users_id_array)
                    ->orWhereIn('created_by', $all_reporting_users_id_array);
            })


            ->defaultSort('-created_at')
            ->allowedFilters([

                AllowedFilter::exact('id'),
                AllowedFilter::exact('lead_id'),
                AllowedFilter::scope('today_tasks'),
                AllowedFilter::exact('type', 'create_task_id'),
                AllowedFilter::scope('starts_between'),
                AllowedFilter::scope('task_completed_status'),
                AllowedFilter::scope('task_created'),
                AllowedFilter::scope('search_name'),
            ])
            ->jsonPaginate(15)
            ->appends(request()->query());


        return (new TaskCollection($tasks))->additional(['message' => "Tasks"]);
    }

    public function store(TaskRequest $request): JsonResponse
    {
        try {
            $user = auth()->user();
            $task = Task::create([
                'lead_id' => $request->lead_id,
                'create_task_id' => $request->create_task_id,
                'followup_by' => $request->followup_by,
                'lead_category' => $request->lead_category,
                'followup_type' => $request->followup_type ?: null,
                'schedule_date' => $request->schedule_date,
                'schedule_time' => $request->schedule_time,
                'reminder' => $request->reminder,
                'project' => $request->project,
                'lead_stage' => $request->lead_stage,
                'remarks' => $request->remarks,
                'budget' => $request->budget ?: null,
                'created_by' => $user->id,
            ]);

            if ($task) {
                $project = PreferredProject::find($request->project);
                $type = Null;
                if ($project) {
                    $type = $project->project_type;
                }
                $lead = Lead::find($task->lead_id);
                $lead->lead_stage_id = $request->lead_stage ? $request->lead_stage : NULL;
                $lead->lead_category = $request->lead_category ? $request->lead_category : NULL;
                $lead->preferred_project = $request->project ?  $request->project : NULL;
                $lead->project_type = $type;

                $lead->save();
                // log Activity
                $activitySubject = $user->name . ' added a new task with ID : ' . $task->id;
                ActivityLog::addToLog($activitySubject, 'leads');

                return $this->success(
                    'Task has been added successfully.',
                );
            }
        } catch (\Throwable $th) {
            info($th);
            return $this->error(
                'Something went wrong,Please try again.',
            );
        }
    }
    // public function Actionstore(TaskActionRequest $request): JsonResponse
    // {
    //     try {
    //         $user = auth()->user();
    //         $task = Task::create([
    //             'lead_id' => $request->lead_id,
    //             'create_task_id' => $request->create_task_id,
    //             'followup_by' => $request->followup_by,
    //             'lead_category' => $request->lead_category,
    //             'followup_type' => $request->followup_type ?: null,
    //             'schedule_date' => $request->schedule_date,
    //             'schedule_time' => $request->schedule_time,
    //             'reminder' => $request->reminder,
    //             'project' => $request->project,
    //             'lead_stage' => $request->lead_stage,
    //             'remarks' => $request->remarks,
    //             'budget' => $request->budget ?: null,
    //             'created_by' => $user->id,
    //         ]);

    //         if ($task) {
    //             $lead = Lead::find($task->lead_id);
    //             $lead->lead_stage_id = $request->lead_stage ? $request->lead_stage : NULL;
    //             $lead->lead_category = $category;

    //             $lead->save();
    //             // log Activity
    //             $activitySubject = $user->name . ' added a new task with ID : ' . $task->id;
    //             ActivityLog::addToLog($activitySubject, 'leads');

    //             return $this->success(
    //                 'Task has been added successfully.',
    //             );
    //         }
    //     } catch (\Throwable $th) {
    //         info($th);
    //         return $this->error(
    //             'Something went wrong,Please try again.',
    //         );
    //     }
    // }

    public function show(Task $task)
    {
        return $this->success(
            'Task details',
            new TaskResource($task->loadMissing(
                'getTaskType',
                'getFollowupBy',
                'getProject',
                'getLeadCategory',
                'getLeadStage',
                'getFollowupStatus',
                'getSiteVisitStatus',
                'getBudget',
                'getCreatedBy'
            ))
        );
    }

    public function destroy(Task $task): JsonResponse
    {
        $task->delete();
        return $this->success(
            'Task deleted successfully.',
        );
    }
    public function search()
    {

        $all_reporting_users_id_array = [];
        $userRoles = auth()
            ->user()
            ->userRoles();
        $date = date('Y-m-d');

        $authUser = auth()->user();
        if (!$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin') && !$userRoles->contains('slug', 'sales-head')) { //Except superadmin and admin
            $all_reporting_users_id_array = $authUser->getAllReportingUsersIds();
            array_push($all_reporting_users_id_array, $authUser->id);
        }


        $tasks = QueryBuilder::for(Task::class)

            ->with([
                'getTaskType',
                'getFollowupBy',
                'getProject',
                'getLeadCategory',
                'getLeadStage',
                'getFollowupStatus',
                'getSiteVisitStatus',
                'getBudget',
                'getCreatedBy',
                'getLead'
            ])
            ->where(function ($query) use ($all_reporting_users_id_array) {
                $query->whereIn('followup_by', $all_reporting_users_id_array)
                    ->orWhereIn('created_by', $all_reporting_users_id_array);
            })
            ->allowedFilters([
                AllowedFilter::scope('search')
            ])

            ->defaultSort('-created_at')
            ->jsonPaginate()
            ->appends(request()->query());
        return (new TaskCollection($tasks))->additional(['message' => "Tasks"]);
    }
}
