<?php

namespace App\Api\Http\Controllers\Api\V1\Task;

use App\Api\Http\Requests\Task\TaskMakeNewRequest;
use App\Api\Http\Requests\Task\TaskNewStatusRequest;
use App\Api\Http\Requests\Task\TaskStatusRequest;
use App\Http\Controllers\Controller;
use App\Lead;
use App\Task;
use Illuminate\Http\JsonResponse;

class TaskStatusController extends Controller
{
    public function status(TaskStatusRequest $request, Task $task): JsonResponse
    {
        $task->task_completed_status = 1;
        $task->task_completion_remarks = $request->task_completion_remarks;
        $task->save();
        if ($request->task_sale_status) {
            $lead = Lead::find($request->lead_id);
            if ($lead) {
                $lead->task_sale_status = $request->task_sale_status;
                $lead->save();
            }
        }

        return $this->success(
            'Task status updated successfully.',
        );
    }
    public function statusChange(TaskNewStatusRequest $request, Task $task): JsonResponse
    {
        $task->task_completed_status = 1;
        $task->task_completion_remarks = $request->task_completion_remarks;
        $task->latitude = $request->latitude;
        $task->longitude = $request->longitude;
        if ($request->has('image')) {
            $task->image = $request->file('image')->store('Task', 'uploads');
        }
        $task->place_address = $request->place_address;
        if( $task->save()){
            $lead = Lead::find($task->lead_id);
            $lead->latitude = $request->latitude ? $request->latitude : NULL;
            $lead->longitude = $request->longitude ? $request->longitude : NULL;
            $lead->place_address = $request->place_address ? $request->place_address : NULL;

            $lead->save();
            return $this->success(
                'Task status updated successfully.',
            );
        }
   
  
      
    }

    public function MakeNewAppointment(TaskMakeNewRequest $request, Task $task)
    {
        $task->task_completed_status = 1;
        $task->task_completion_remarks = $request->task_completion_remarks;
        $task->save();
        return $this->success(
            'Task status updated successfully.',
        );
    }

    public function InvalidTask(TaskMakeNewRequest $request, Task $task)
    {
        try {
          
            $task->task_completed_status = 1;
            $task->task_completion_remarks = $request->task_completion_remarks;
            if ($task->save()) {
                $user = auth()->user();
                $newtask = Task::create([
                    'lead_id' => $request->lead_id,
                    'create_task_id' => 5,
                    'followup_by' => $user->id,
                    'lead_category' => 4,
                    'lead_stage' => 6,
                    'task_completion_remarks'  =>$task->task_completion_remarks,
                    'created_by' => $user->id,
                    'task_completed_status' => 1,
                ]);
                
                if ($newtask) {
                    $lead = Lead::find($task->lead_id);
                    $lead->lead_stage_id =  $newtask->lead_stage ?$newtask->lead_stage: NULL;
                    $lead->lead_category =   $newtask->lead_category ? $newtask->lead_category : NULL;
    
                    $lead->save();
    
    
                    return $this->success(
                        'Task status updated successfully.',
                    );
                }
            }
            return $this->error(
                'Something went wrong,Please try again.',
            );
        } catch (\Throwable $th) {
            info($th);
            return $this->error(
                'Something went wrong,Please try again.',
            );
        }
       

      
    }
}
