<?php

namespace App\Api\Http\Controllers\Api\V1\TaskType;

use App\Api\Http\Resources\TaskType\TaskTypeCollection;
use App\CreateTask;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class TaskTypeController extends Controller
{
    public function tasks(Request $request): JsonResponse
    {
        $taskTypes = CreateTask::where('status', 1)->where('task_status', 1)->get();

        return $this->success(
            'Task Types!',
            new TaskTypeCollection($taskTypes)
        );
    }

    public function Actiontasks(Request $request): JsonResponse
    {
        $taskTypes = CreateTask::where('status', 1)->where('task_action', 1)->get();

        return $this->success(
            'Task Types!',
            new TaskTypeCollection($taskTypes)
        );
    }

    public function UnnAttendedtasks(Request $request): JsonResponse
    {
        $taskTypes = CreateTask::where('unnattended_filter', 1)
        ->orderBy('id', 'desc')
        ->get();
    
    return $this->success(
        'Task Types!',
        new TaskTypeCollection($taskTypes)
    );
    }
}
