<?php

namespace App\Api\Http\Controllers\Api\V1\User;

use App\Api\Http\Requests\RegisterRequest;
use App\Http\Controllers\Controller;
use App\User;
use App\Api\Http\Resources\User\UserResource;
use App\Role;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{


    public function index(): JsonResponse
    {
        $authUser = auth()->user();

        $user = User::query()
            ->where('id', $authUser->id)
            ->first();

        return $this->success(
            'Profile fetched!',
            new UserResource($user)
        );
    }
  
    public function DeleteAccount(): JsonResponse
    {
        /** @var User $authUser */
        $authUser = Auth::user();
        $authUser->status = 0;
        $authUser->save();

        return response()->json([
            'message' => 'Deleted Account',
        ]);
    }
}
