<?php

namespace App\Api\Http\Controllers\Api\V1\userLeadList;

use App\Api\Http\Resources\Leads\LeadCollection;
use App\Api\Http\Resources\User\UserResource;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Lead;
use App\User;
use Illuminate\Http\Request;

class UserLeadListController extends Controller
{
    public function list(Request $request)
    {
        $user = Auth::user();
        $query = Lead::
            where(function ($query) use ($user) {
                $query->where('created_by', $user->id)
                      ->orWhere('attended_by', $user->id);
            });
    
        if ($request->has('mobile')) {
            $mobile = $request->input('mobile');
            $query->where('mobile', 'like', '%' . $mobile . '%');
        }
    
        $lead = $query->get();
    
        return response()->json([
            'status' => true,
            'data' => New LeadCollection($lead)
        ]);
    }
    

    
}
