<?php

namespace App\Api\Http\Controllers\Api\V2\Contest;

use App\Branch;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\DsrBooking;
use Carbon\CarbonPeriod;
use App\Api\Http\Requests\DailySales\DailySalesListRequest;
use App\DsrSplit;
use App\Quarter;
use App\User;

class ContestFilterController extends Controller
{
    public function contest()
    {
        $today = Carbon::today()->format('d-m-Y');
        $week = Carbon::today()->subDays(15)->format('d-m-Y');
        $seven = Carbon::today()->subDays(7)->format('d-m-Y');
        $month = Carbon::now()->subMonth()->format('d-m-Y');
        $yesterday = Carbon::yesterday()->toDateString();
        $formattedYesterday = Carbon::parse($yesterday)->format('d-m-Y');
        $currentDate = date('Y-m-d');
        $quarter = Quarter::whereRaw('? between date_from and date_to', $currentDate)
            ->first();

        if ($quarter) {
            $formattedDateFrom = Carbon::parse($quarter->date_from)->format('d-m-Y');
            $formattedDateTo = Carbon::parse($quarter->date_to)->format('d-m-Y');
        }

        $data = [
            [
                'title' => 'Today',
                'id' => 1,
                'from_date' => $today,
                'to_date' => $today
            ],
            [
                'title' => 'Yesterday',
                'id' => 5,
                'from_date' => $formattedYesterday,
                'to_date' => $formattedYesterday
            ],
            [
                'title' => 'Last 7 days',
                'id' => 7,
                'from_date' => $seven,
                'to_date' => $today
            ],
            [
                'title' => 'Last 15 days',
                'id' => 2,
                'from_date' => $week,
                'to_date' => $today
            ],
            [
                'title' => 'Last 30 days',
                'id' => 3,
                'from_date' => $month,
                'to_date' => $today
            ],
            [
                'title' => 'Quarter',
                'id' => 8,
                'from_date' => $formattedDateFrom,
                'to_date' => $formattedDateTo
            ],
            // [
            //     'title' => 'Contest',
            //     'id' => 6,
            //     'from_date' =>
            //     'to_date' => 
            // ],

        ];

        return response()->json([
            'status' => true,
            'day_filters' => $data,
        ]);
    }
}
