<?php

namespace App\Api\Http\Controllers\Api\V2\Home;

use App\DailyActivityCalculation;
use App\Lead;
use App\User;
use App\DailyWorkEfficiency;
use App\DsrBooking;
use App\DsrSplit;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Notification;
use App\Quarter;
use App\Task;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class HomeNewController extends Controller
{
    protected function calculateIndividualTotals($user, $quarterlyTarget)
    {
        $individualDsrBooking = DsrBooking::where('split', 1)
            ->where('sales_person_id', $user->id)
            ->when($quarterlyTarget, function ($query, $quarterlyTarget) {
                return $query->where('quarter', $quarterlyTarget->name);
            })
            ->get();
        $individualDsrSplit = DsrSplit::where('user_id', $user->id)
            ->when($quarterlyTarget, function ($query, $quarterlyTarget) {
                return $query->where('quarter', $quarterlyTarget->name);
            })

            ->get();

        $individualTotal = [
            'individual_agreement_total_amount' => 0,
            'individual_agreement_total_units' => 0,
        ];

        foreach ($individualDsrBooking as $booking) {
            if ($booking->status === 'AGREEMENTED') {
                $sumAmount = $booking->sale_value;
                $individualTotal['individual_agreement_total_amount'] += $sumAmount;

                $sumUnit = 1;

                $individualTotal['individual_agreement_total_units'] += $sumUnit;
            }
        }
        foreach ($individualDsrSplit as $split) {
            if ($split->status === 'AGREEMENTED') {
                $sumAmount = $split->amount;
                $individualTotal['individual_agreement_total_amount'] += $sumAmount;

                $sumUnit = 1 / $split->split;

                $individualTotal['individual_agreement_total_units'] += $sumUnit;
            }
        }

        return $individualTotal;
    }

    public function index(Request $request)
    {
        $user = auth()->user();
        $currentDate = date('Y-m-d');

        $user->update([
            'device_type' => $request->device,
            'app_version' => $request->app_version,
            'device_name' => $request->device_name,
        ]);

        $userName = $user->name;
        $subTitle = 'Make Today Count!';
        $userRoles = $user->userRoles();

        // Collect reporting users IDs based on roles
        $all_reporting_users_id_array = [];
        $authUser = auth()->user();
        if (!$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin')) {
            $all_reporting_users_id_array = $authUser->getAllReportingUsersIds();
            array_push($all_reporting_users_id_array, $authUser->id);
        }

        $task_count = Task::with([
            'getTaskType',
            'getFollowupBy',
            'getProject',
            'getLeadCategory',
            'getLeadStage',
            'getFollowupStatus',
            'getSiteVisitStatus',
            'getBudget',
            'getCreatedBy',
            'getLead',
        ])
            ->where(function ($query) use ($all_reporting_users_id_array) {
                $query->whereIn('followup_by', $all_reporting_users_id_array)
                    ->orWhereIn('created_by', $all_reporting_users_id_array);
            })
            ->where(function ($query) {
                $query->whereDate('reminder', now()->format('Y-m-d'))
                    ->orWhereDate('schedule_date', now()->format('Y-m-d'));
            })
            ->get()
            ->count();

        $unnattended = Lead::with('getLeadCategory', 'getPreferredProject')
            ->where('is_ceo_verified', '1')
            ->when(is_array($all_reporting_users_id_array), function ($query) use ($all_reporting_users_id_array) {
                return $query->whereIn('attended_by', $all_reporting_users_id_array);
            }, function ($query) use ($all_reporting_users_id_array) {
                return $query->where('attended_by', $all_reporting_users_id_array);
            })
            ->whereHas('getSource', function ($query) {
                $query->where('status', 0);
            })
            ->where('is_attended', 0)

            ->count();

        $reallocated = Lead::with('getLeadCategory', 'getPreferredProject')
            ->where('is_ceo_verified', '1')
            ->when(is_array($all_reporting_users_id_array), function ($query) use ($all_reporting_users_id_array) {
                return $query->whereIn('re_attended_by', $all_reporting_users_id_array);
            }, function ($query) use ($all_reporting_users_id_array) {
                return $query->where('re_attended_by', $all_reporting_users_id_array);
            })
            ->where('reallocate_new', 1)
            ->count();

        $allocationLeadsCount = Lead::where('is_ceo_verified', 1)
            ->where('attended_by', $user->id)
            ->where('sale_status', '!=', 'yes')
            ->where('show_in_salesperson_actions', 1)
            ->count();

        $leads = Lead::with([
            'getLeadStage',
            'getUnit',
            'getAttendedBy',
            'getSource',
            'getProjectType',
            'getPreferredProject',
            'getPreferredProject.getProjectType',
            'getBudget',
            'getLeadCategory',
        ])
            ->where(function ($query) {
                $query->whereNotIn('lead_stage_id', [6, 7, 8])->orWhereNull('lead_stage_id');
            })
            ->when($userRoles->contains('slug', 'executive'), function ($q) {
                $q->where('is_attended', 1);
            })
            ->when(!$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin') && !$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'sales-head'), function ($q) use ($all_reporting_users_id_array) {
                $q->whereIn('attended_by', $all_reporting_users_id_array);
            })
            ->where('sale_status', 'no')
            ->get();

        $projectTypeCounts = $leads->groupBy('project_type')->map->count();

        $leadsDetails = [
            'total' => $leads->count(),
            'residential' => [
                'id' => 1,
                'count' => $projectTypeCounts[1] ?? 0,
                'colorCode' => '#6933CA',
            ],
            'commercial' => [
                'id' => 2,
                'count' => $projectTypeCounts[2] ?? 0,
                'colorCode' => '#FE795A',
            ],
            'retail' => [
                'id' => 3,
                'count' => $projectTypeCounts[3] ?? 0,
                'colorCode' => '#00CF6B',
            ],
            'others' => [
                'id' => 0,
                'count' => Lead::where('attended_by', $user->id)->where('project_type', null)->where('reallocate_new', 0)->count(),
                'colorCode' => '#1CABE1',
            ],
        ];

        $currentDate = date('Y-m-d');

        $notificationCount = Notification::where('user_id', $user->id)->where('status', 0)->count();

        $taskStatusCount = Task::where(function ($query) use ($user) {
            $query->where('followup_by', $user->id)
                ->orWhere('created_by', $user->id);
        })
            ->where('task_completed_status', 0)
            ->count();

        if ($taskStatusCount > 0) {
            $addLead = 1;
        } else {
            $addLead = 0;
        }

        $id = $user->id;
        $lists = $request->list;
        $week = Carbon::today()->subDays(15);
        $seven = Carbon::today()->subDays(7);
        $month = Carbon::now()->subMonth();
        $yesterday = Carbon::yesterday()->toDateString();
        $currentDate = date('Y-m-d');
        $quarter = Quarter::whereRaw('? between date_from and date_to', $currentDate)
            ->first();

        if ($quarter) {
            $from_date = $quarter->date_from;
            $to_date = $quarter->date_to;
        }

        $tasks = Task::where('created_by', $user->id)
            ->where('task_completed_status', 1)
            ->when($lists == 1, function ($query) {
                $query->whereDate('schedule_date', today());
            })
            ->when($lists == 2, function ($query) use ($week) {
                $query->whereDate('schedule_date', '>=', $week);
            })
            ->when($lists == 3, function ($query) use ($month) {
                $query->whereDate('schedule_date', '>=', $month);
            })
            ->when($lists == 4, function ($query) use ($request) {
                $from = $request->from_date;
                $to = $request->to_date;
                $query->whereBetween('schedule_date', [$from, $to]);
            })
            ->when($lists == 5, function ($query) use ($yesterday) {
                $query->whereDate('schedule_date', '=', $yesterday);
            })
            ->when($lists == 6, function ($query) {
                $query->whereBetween('schedule_date', ['2023-11-20', '2023-12-31']);
            })
            ->when($lists == 7, function ($query) use ($seven) {
                $query->whereDate('schedule_date', '>=', $seven);
            })
            ->when($lists == 8, function ($query) use ($from_date, $to_date) {
                $query->whereBetween('schedule_date', [$from_date, $to_date]);
            })
            ->whereIn('create_task_id', [2, 3, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19])
            ->where(function ($query) {
                $query->whereIn('create_task_id', [2, 3, 13, 14, 12, 19])
                    ->where('team_leader_approved', 1);
            })
            ->orWhere(function ($query) use ($user, $lists, $week, $month, $request, $yesterday, $seven, $from_date, $to_date) {
                $query->where('created_by', $user->id)
                    ->whereIn('create_task_id', [10, 11, 15, 16, 17, 18])
                    ->when($lists == 1, function ($query) {
                        $query->whereDate('schedule_date', today());
                    })
                    ->when($lists == 2, function ($query) use ($week) {
                        $query->whereDate('schedule_date', '>=', $week);
                    })
                    ->when($lists == 3, function ($query) use ($month) {
                        $query->whereDate('schedule_date', '>=', $month);
                    })
                    ->when($lists == 4, function ($query) use ($request) {
                        $from = $request->from_date;
                        $to = $request->to_date;
                        $query->whereBetween('schedule_date', [$from, $to]);
                    })
                    ->when($lists == 5, function ($query) use ($yesterday) {
                        $query->whereDate('schedule_date', '=', $yesterday);
                    })
                    ->when($lists == 6, function ($query) {
                        $query->whereBetween('schedule_date', ['2023-11-20', '2023-12-31']);
                    })
                    ->when($lists == 7, function ($query) use ($seven) {
                        $query->whereDate('schedule_date', '>=', $seven);
                    })
                    ->when($lists == 8, function ($query) use ($from_date, $to_date) {
                        $query->whereBetween('schedule_date', [$from_date, $to_date]);
                    });
            })
            ->select('tasks.*', DB::raw('(SELECT MAX(point) FROM daily_activity_calculations WHERE create_task_id = tasks.create_task_id) as max_point'))
            ->get()
            ->groupBy('lead_id');

        $calculations = DailyActivityCalculation::get();
        $leadPoint = DailyActivityCalculation::find(1)->point ?? 0;

        $tasks->transform(function ($leadTasks) {
            return $leadTasks->sortByDesc('max_point')->first();
        });

        $leadsToSkip = $tasks->pluck('lead_id');

        // $newLeadCount = Lead::where('created_by', $id)
        //     ->where('lead_date', $currentDate)
        //     ->where('duplicate_entry', 'no')
        //     ->whereNotIn('id', $leadsToSkip)
        //     ->count();

        // $newLeadCount = Lead::where(function ($query) use ($id) {
        //     $query->where('created_by', $id)
        //         ->orWhere('attended_by', $id);
        // })
        // ->when($lists == 1, function ($query) {
        //     $query->whereDate('lead_date', today());
        // })
        // ->when($lists == 2, function ($query) use ($week) {
        //     $query->whereDate('lead_date', '>=', $week);
        // })
        // ->when($lists == 3, function ($query) use ($month) {
        //     $query->whereDate('lead_date', '>=', $month);
        // })
        // ->when($lists == 4, function ($query) use ($request) {
        //     $from = $request->from_date;
        //     $to = $request->to_date;
        //     $query->whereBetween('lead_date', [$from, $to]);
        // })
        // ->when($lists == 5, function ($query) use ($yesterday) {
        //     $query->whereDate('lead_date', '=', $yesterday);
        // })
        // ->when($lists == 6, function ($query) {
        //     $query->whereBetween('lead_date', ['2023-11-20', '2023-12-31']);
        // })
        // ->when($lists == 7, function ($query) use ($seven) {
        //     $query->whereDate('lead_date', '>=', $seven);
        // })
        // ->when($lists == 8, function ($query) use($from_date, $to_date){
        //     $query->whereBetween('lead_date', [$from_date, $to_date]);
        // })
        // ->where('duplicate_entry', 'no')
        // ->whereNotIn('id', $leadsToSkip)
        // ->count();

        // $leadCalculation = number_format($newLeadCount * $leadPoint, 3);
        $siteVist = $tasks->where('create_task_id', 2)->count();
        $sitePoint = $calculations->where('create_task_id', 2)->first()->point;
        $totalSitepoint = number_format($siteVist * $sitePoint, 3);

        $officeVist = $tasks->where('create_task_id', 13)->count();
        $OfficePoint = $calculations->where('create_task_id', 13)->first()->point;
        $totalOfficePoint = number_format($officeVist * $OfficePoint, 3);
        $directMarketing = $tasks->where('create_task_id', 11)->count();

        $directMarketingPoint = $calculations->where('create_task_id', 11)->first()->point;
        $totalDirectMarketingPoint = number_format($directMarketing * $directMarketingPoint, 3);
        $mallCounter = $tasks->where('create_task_id', 10)->count();
        $mallCounterPoint = $calculations->where('create_task_id', 10)->first()->point;
        $totalMallCounterPoint = number_format($mallCounter * $mallCounterPoint, 3);

        $appointments = $tasks->where('create_task_id', 3)->count();
        $appointmentPoint = $calculations->where('create_task_id', 3)->first()->point;
        $totalAppointmentPoint = number_format($appointments * $appointmentPoint, 3);

        $virtual = $tasks->where('create_task_id', 12)->count();
        $virtualPoint = $calculations->where('create_task_id', 12)->first()->point;
        $totalVirtualPoint = number_format($virtual * $virtualPoint, 3);

        $followuptasks = $tasks->where('create_task_id', 19);
        $countWithNullImageAndDuration = $followuptasks->filter(function ($task) {
            return $task->image == null && $task->duration >= 120;
        })->count();

        $countWithNotNullImageAndTeamLeaderApprove = $followuptasks->filter(function ($task) {
            return $task->image != null && $task->team_leader_approved == 1;
        })->count();
        $followup = $countWithNullImageAndDuration + $countWithNotNullImageAndTeamLeaderApprove;
        $followupCount = $calculations->where('create_task_id', 19)->first()->point;
        $followupPoint = number_format($followup * $followupCount, 3);

        $fresh = $tasks->where('create_task_id', 15)->count();
        $freshRuno = $tasks->where('create_task_id', 17)->where('duration', '>', 30)->count();
        $freshCall = $fresh + $freshRuno;
        $freshCallPoint = $calculations->where('create_task_id', 15)->first()->point;
        $totalFreshCallPoint = number_format($freshCall * $freshCallPoint, 3);

        $freshNri = $tasks->where('create_task_id', 16)->count();
        $freshNriRuno = $tasks->where('create_task_id', 18)->where('duration', '>', 30)->count();
        $freshCallNriPoint = $calculations->where('create_task_id', 16)->first()->point;
        $freshCallNri = $freshNri + $freshNriRuno;
        $totalFreshCallNriPoint = number_format($freshCallNri * $freshCallNriPoint, 3);

        $connectHeads = $tasks->where('create_task_id', 14)->count();
        $connectHeadsPoint = $calculations->where('create_task_id', 14)->first()->point;
        $totalconnectHeadsPoint = number_format($connectHeads * $connectHeadsPoint, 3);

        $data = [
            [
                'activity_type' => 'Appointment',
                'id' => 3,
                'point' => $totalAppointmentPoint ?? '0.0',
                'count' => strval($appointments),
                'colorCode' => '#4285F4',
            ],
            [
                'activity_type' => 'Site Visit',
                'id' => 2,
                'point' => $totalSitepoint ?? '0.0',
                'count' => strval($siteVist),
                'colorCode' => '#EA4335',
            ],

            [
                'activity_type' => 'Office Visit',
                'id' => 13,
                'point' => $totalOfficePoint ?? '0.0',
                'count' => strval($officeVist),
                'colorCode' => '#FBBC05',
            ],
            [
                'activity_type' => 'Virtual Meeting',
                'id' => 12,
                'point' => $totalVirtualPoint ?? '0.0',
                'count' => strval($virtual),
                'colorCode' => '#34A853',
            ],
            [
                'activity_type' => 'Call Connected to Heads',
                'id' => 14,
                'point' => $totalconnectHeadsPoint ?? '0.0',
                'count' => strval($connectHeads),
                'colorCode' => '#A311A6',
            ],
            [
                'activity_type' => 'Direct Marketing',
                'id' => 11,
                'point' => $totalDirectMarketingPoint ?? '0.0',
                'count' => strval($directMarketing),
                'colorCode' => '#375559',
            ],
            [
                'activity_type' => 'Mall Counter',
                'id' => 10,
                'point' => $totalMallCounterPoint ?? '0.0',
                'count' => strval($mallCounter),
                'colorCode' => '#C29B2A',
            ],
            [
                'activity_type' => 'Follow Up Call',
                'id' => 19,
                'point' => $followupPoint ?? '0.0',
                'count' => strval($followup),
                'colorCode' => '#279548',
            ],
            [
                'activity_type' => 'Fresh Call (NRI)',
                'id' => 16,
                'point' => $totalFreshCallNriPoint ?? '0.0',
                'count' => strval($freshCallNri),
                'colorCode' => '#C254C5',
            ],
            [
                'activity_type' => 'Fresh Call (Resident)',
                'id' => 15,
                'point' => $totalFreshCallPoint ?? '0.0',
                'count' => strval($freshCall),
                'colorCode' => '#4A34BE',
            ],

            // [
            //     'activity_type' => 'New lead',
            //     'id' => 50,
            //     'point' => $leadCalculation,
            //     'count' => strval($newLeadCount),
            //     'colorCode' => '#23DAE5'
            // ],

            [
                'activity_type' => 'Sale',
                'id' => 0,
                'point' => '0.0',
                'count' => '0',
                'colorCode' => '#4A34BE',
            ],
        ];

        $totalPoints = 0.0;

        foreach ($data as $item) {
            $totalPoints += $item['point'];
        }
        $usersWorks = DailyWorkEfficiency::where('user_id', $user->id)
        ->when($lists == 1, function ($query) {
            $query->whereDate('date', today());
        })
        ->when($lists == 2, function ($query) use ($week) {
            $query->whereDate('date', '>=', $week);
        })
        ->when($lists == 3, function ($query) use ($month) {
            $query->whereDate('date', '>=', $month);
        })
        ->when($lists == 4, function ($query) use ($request) {
            $from = $request->from_date;
            $to = $request->to_date;
            $query->whereBetween('date', [$from, $to]);
        })
        ->when($lists == 5, function ($query) use ($yesterday) {
            $query->whereDate('date', '=', $yesterday);
        })
        ->when($lists == 6, function ($query) {
            $query->whereBetween('date', ['2023-11-20', '2023-12-31']);
        })
        ->when($lists == 7, function ($query) use ($seven) {
            $query->whereDate('date', '>=', $seven);
        })
        ->when($lists == 8, function ($query) use ($from_date, $to_date) {
            $query->whereBetween('date', [$from_date, $to_date]);
        })
        ->get();

        $totalEfficiency = $usersWorks->sum('work_efficiency');

        $task = [
            'current_date' => $currentDate,
            // 'total_points' => number_format($totalPoints, 3),
            'total_points' => number_format($totalEfficiency, 3),
            'data' => $data,
        ];

        $dsrSplit = DsrSplit::where('user_id', $user->id)
        ->where('status', 'AGREEMENTED')
        ->get();

        $dsrBooking = DsrBooking::where('sales_person_id', $user->id)
        ->where('status', 'AGREEMENTED')
        ->get();

        $combinedData = $dsrSplit->merge($dsrBooking);

        if ($combinedData->isNotEmpty()) {
            $latest = $combinedData->sortByDesc(function ($item) {
                return $item instanceof DsrBooking ? $item->agreement_date : ($item->getDsrBooking ? $item->getDsrBooking->agreement_date : null);
            })->first();

            $latestBooking = $latest instanceof DsrBooking
            ? $latest->agreement_date
            : ($latest->getDsrBooking ? $latest->getDsrBooking->agreement_date : '');

            $dateCount = $latestBooking ? Carbon::now()->diffInDays($latestBooking) : null;
        } else {
            $latestBooking = '';
            $dateCount = '';
        }

        $dailyWorkPlanPointDate = Carbon::parse($user->daily_work_plan_point_date)->format('Y-m-d');
        $today = Carbon::now()->format('Y-m-d');

        if ($dailyWorkPlanPointDate == $today) {
            $daily_work_plan_point = $user->daily_work_plan_point;
        } else {
            $daily_work_plan_point = 'Not Submitted';
        }

        if ($task['total_points'] >= 8) {
            $color = '#008000';
        } elseif ($task['total_points'] > 5 && $task['total_points'] < 8) {
            $color = '#FFA500';
        } else {
            $color = '#FF0000';
        }

        return response()->json([
            'message' => 'Success',
            'data' => [
                'userName' => $userName,
                'subTitle' => $subTitle,
                'leadsDetails' => $leadsDetails,
                'today_tasks' => $task_count ?? '0',
                'unnattended' => $unnattended ?? '0',
                'reallocated' => $reallocated ?? '0',
                'allocation_leads_count' => $allocationLeadsCount,
                'user_status' => $user->status,
                'Notification' => $notificationCount ?? 0,
                'task_create_status' => $addLead,
                'daily_work_plan_status' => '0',
                'work_efficiency' => floor($task['total_points'] ?? 0.00),
                'color' => $color,
                'task' => $task,
                'last_sale_date' => $latestBooking,
                'last_sale_date_count' => strval($dateCount) ?? '',
                'daily_work_plan_point' => $daily_work_plan_point,
            ],
        ]);
    }

    public function rankList(Request $request)
    {
        $user = auth()->user();
        $userRoles = auth()
        ->user()
        ->userRoles();

        $authUser = auth()->user();

        $currentDate = date('Y-m-d');
        $quarterlyTarget = Quarter::whereRaw('? between date_from and date_to', $currentDate)
            ->first();
        $executivesList = User::with(['roles'])
            ->whereHas('roles', function ($q) {
                $q->where('role_id', 8);
            })
            ->where('status', 1)
            ->where('reporting_to', '!=', 282)
            ->where('id', '!=', 97);

        // if (!$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin') && !$userRoles->contains('slug', 'sales-head') && !$userRoles->contains('slug', 'head-sales') && !$userRoles->contains('slug', 'head-sales-2') ) {
        //     $executivesList->where('branch_id', auth()->user()->branch_id);
        // } elseif ($request->input('branch_id')) {
        //     $executivesList->where('branch_id', $request->input('branch_id'));
        // }

        $executivesList = $executivesList->get();

        $teamLeadersList = User::with('roles', 'getDailySaleReport')
        ->whereHas('roles', function ($query) {
            $query->where('id', 7);
        })
        ->where('status', 1)
        ->whereNotIn('id', [282, 276]);

        // if (!$userRoles->contains('slug', 'ceo') && !$userRoles->contains('slug', 'super-admin') && !$userRoles->contains('slug', 'admin') && !$userRoles->contains('slug', 'sales-head') && !$userRoles->contains('slug', 'head-sales') && !$userRoles->contains('slug', 'head-sales-2')){
        //     $teamLeadersList->where('branch_id', auth()->user()->branch_id);
        // } elseif ($request->input('branch_id')) {
        //     $teamLeadersList->where('branch_id', $request->input('branch_id'));
        // }
        $teamLeadersList = $teamLeadersList->get();

        $teamLeadersRankList = $teamLeadersList->map(function ($item, $key) use ($quarterlyTarget) {
            $teamMembers = User::where('reporting_to', $item->id)->where('status', 1)->get();

            $teamMembers->each(function ($member) use ($quarterlyTarget) {
                $member->individual_totals = $this->calculateIndividualTotals($member, $quarterlyTarget);
            });

            $item->individual_totals = $this->calculateIndividualTotals($item, $quarterlyTarget);
            $teamTotals = $teamMembers->pluck('individual_totals')->push($item->individual_totals);

            $teamAgreementTotalAmount = $teamTotals->sum('individual_agreement_total_amount');
            $teamAgreementTotalUnits = $teamTotals->sum('individual_agreement_total_units');

            return [
                'id' => $item->id,
                'name' => $item->name,
                'amount' => $teamAgreementTotalAmount,
                'units' => $teamAgreementTotalUnits,
                'image' => $item->image ? url("uploads/$item->image") : '',
            ];
        });
        $teamLeadersListByRank = $teamLeadersRankList->sortByDesc('amount')->values();

        $teamLeadersListByRank->transform(function ($item, $key) {
            $item['rank'] = $key + 1;

            $val = $item['amount'] / 100000;
            $val = ceil($val);
            $finalVal = $val.' lakh';

            $item['amount'] = $finalVal;

            return $item;
        });

        $teamLeadersRanksList = $teamLeadersListByRank->take(10);

        $executivesRankList = $executivesList->map(function ($item, $key) use ($quarterlyTarget) {
            $individual_totals = $this->calculateIndividualTotals($item, $quarterlyTarget);
            $userAgreementTotalAmount = $individual_totals['individual_agreement_total_amount'];
            $userAgreementTotalUnits = $individual_totals['individual_agreement_total_units'];

            return [
                'id' => $item->id,
                'name' => $item->name,
                'units' => $userAgreementTotalUnits,
                'amount' => $userAgreementTotalAmount,
                'image' => $item->image ? url("uploads/$item->image") : '',
            ];
        });

        $executivesListByRank = $executivesRankList->sortByDesc('amount')->values();
        $executivesListByRank->transform(function ($item, $key) {
            $item['rank'] = $key + 1;

            $val = $item['amount'] / 100000;
            $val = ceil($val);
            $finalVal = $val.' lakh';

            $item['amount'] = $finalVal;

            return $item;
        });

        $executivesRanksList = $executivesListByRank->take(10);
        if (auth()->user()->hasRole('executive')) {
            $myrankingList = $executivesListByRank;
        } else {
            $myrankingList = $teamLeadersListByRank;
        }

        $DsrBooking = DsrBooking::where('split', 1)
            ->where('status', 'AGREEMENTED')
            ->where('branch_id', auth()->user()->branch_id)
            ->where('quarter', $quarterlyTarget->name)
            ->get();

        $DsrSplit = DsrSplit::where('branch_id', auth()->user()->branch_id)
            ->where('status', 'AGREEMENTED')
            ->where('quarter', $quarterlyTarget->name)
            ->get();

        $totalAmount = 0;

        foreach ($DsrBooking as $booking) {
            $totalAmount += $booking->sale_value;
        }

        foreach ($DsrSplit as $split) {
            $totalAmount += $split->amount;
        }

        $sale_value = ceil($totalAmount / 100000).' lakh';

        $myRanking = [
            'id' => $user->id,
            'name' => $user->name,
            'rank' => $myrankingList->where('id', $user->id)->first()['rank'] ?? 0,
            'amount' => $myrankingList->where('id', $user->id)->first()['amount'] ?? '0',
            'image' => $user->image ? url("uploads/{$user->image}") : '',
        ];

        if (auth()->user()->hasRole('team-leader')) {
            $users = User::where('reporting_to', $user->id)
                ->where('status', 1)
                ->get();
            $DsrBooking = DsrBooking::where('split', 1)
                ->where('status', 'AGREEMENTED')
                ->where('branch_id', auth()->user()->branch_id)
                ->whereIn('sales_person_id', $users->pluck('id'))
                ->where('quarter', $quarterlyTarget->name)
                ->count();

            $DsrSplit = DsrSplit::whereIn('user_id', $users->pluck('id'))
                ->where('quarter', $quarterlyTarget->name)
                ->where('status', 'AGREEMENTED')
                ->where('branch_id', auth()->user()->branch_id)
                ->count();

            $sales_this_quarter = $DsrBooking + $DsrSplit;
        } elseif (auth()->user()->hasRole('head-sales') || auth()->user()->hasRole('super-admin') || auth()->user()->hasRole('ceo')) {
            $users = User::whereHas('roles', function ($q) {
                $q->whereIn('role_id', [8, 7]);
            })
                ->where('status', 1)
                ->get();

            $DsrBookingQuery = DsrBooking::where('split', 1)
                ->where('status', 'AGREEMENTED')
                ->whereIn('sales_person_id', $users->pluck('id'))
                ->where('quarter', $quarterlyTarget->name);

            $DsrSplitQuery = DsrSplit::whereIn('user_id', $users->pluck('id'))
                ->where('quarter', $quarterlyTarget->name)
                ->where('status', 'AGREEMENTED');

            if ($request->input('branch_id')) {
                $DsrBookingQuery->where('branch_id', $request->branch_id);
                $DsrSplitQuery->where('branch_id', $request->branch_id);
            }

            $DsrBooking = $DsrBookingQuery->count();
            $DsrSplit = $DsrSplitQuery->count();
            $sales_this_quarter = $DsrBooking;
        } elseif (auth()->user()->hasRole('sales-head')) {
            $users = User::whereHas('roles', function ($q) {
                $q->whereIn('role_id', [8, 7]);
            })->where('status', 1)->where('branch_id', auth()->user()->branch_id)->get();

            $DsrBookingQuery = DsrBooking::where('split', 1)
                ->where('status', 'AGREEMENTED')
                ->whereIn('sales_person_id', $users->pluck('id'))
                ->where('quarter', $quarterlyTarget->name);

            $DsrSplitQuery = DsrSplit::whereIn('user_id', $users->pluck('id'))
                ->where('quarter', $quarterlyTarget->name)
                ->where('status', 'AGREEMENTED');

            $DsrBooking = $DsrBookingQuery->count();
            $DsrSplit = $DsrSplitQuery->count();
            $sales_this_quarter = $DsrBooking + $DsrSplit;
        } else {
            $sales_this_quarter = '0';
        }

        return response()->json([
            'message' => 'Success',
            'data' => [
                'my_ranking' => $myRanking,
                'executives_ranking' => $executivesRanksList,
                'team_leaders_ranking' => $teamLeadersRanksList,
                'sale_value' => $sale_value ?? '0',
                'sales_this_quarter' => strval($sales_this_quarter) ?? '0',
            ],
        ]);
    }

    public function workEffeciencyChart(Request $request)
    {
        if ($request->list == 5) {
            $startDate = Carbon::yesterday()->setHour(9)->setMinute(30)->setSecond(0);
            $endDate = Carbon::yesterday()->setHour(23)->setMinute(59)->setSecond(59);
            $hourlyCounts = [];
        } else {
            $startDate = Carbon::now()->setHour(9)->setMinute(30)->setSecond(0);
            $endDate = Carbon::now()->setHour(23)->setMinute(59)->setSecond(59);
            $hourlyCounts = [];
        }
        for ($hour = $startDate->copy(); $hour->lt($endDate); $hour->addHour()) {
            $tasks = Task::where('task_completed_status', 1)
                    ->whereBetween('created_at', [$hour, $hour->copy()->addHour()])
                    ->whereIn('create_task_id', [2, 3, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19])
                    ->where(function ($query) {
                        $query->whereIn('create_task_id', [2, 3, 13, 14, 12, 19])
                            ->where('team_leader_approved', 1);
                    })
                    ->orWhere(function ($query) use ($hour) {
                        $query->whereIn('create_task_id', [10, 11, 15, 16, 17, 18])
                        ->whereBetween('created_at', [$hour, $hour->copy()->addHour()]);
                    })
                    ->select('tasks.*', DB::raw('(SELECT MAX(point) FROM daily_activity_calculations WHERE create_task_id = tasks.create_task_id) as max_point'))
                    ->get()
                    ->groupBy('lead_id');

            $calculations = DailyActivityCalculation::get();
            $leadPoint = DailyActivityCalculation::find(1)->point ?? 0;

            $tasks->transform(function ($leadTasks) {
                return $leadTasks->sortByDesc('max_point')->first();
            });

            $uniquetasks = Task::where('task_completed_status', 1)
                ->whereBetween('created_at', [$hour, $hour->copy()->addHour()])
                ->whereIn('create_task_id', [2, 3, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19])
                ->where(function ($query) {
                    $query->whereIn('create_task_id', [2, 3, 13, 14, 12, 19])
                        ->where('team_leader_approved', 1);
                })
                ->orWhere(function ($query) use ($hour) {
                    $query->whereIn('create_task_id', [10, 11, 15, 16, 17, 18])
                    ->whereBetween('created_at', [$hour, $hour->copy()->addHour()]);
                })
                 ->distinct('followup_by')
              ->count('followup_by');
            $leadsToSkip = $tasks->pluck('lead_id');

            $newLeadCount = Lead::whereBetween('created_at', [$hour, $hour->copy()->addHour()])

                    ->where('duplicate_entry', 'no')
                    ->whereNotIn('id', $leadsToSkip)
                    ->count();

            $leadCalculation = number_format($newLeadCount * $leadPoint, 3);

            $siteVist = $tasks->where('create_task_id', 2)->count();
            $sitePoint = $calculations->where('create_task_id', 2)->first()->point;
            $totalSitepoint = number_format($siteVist * $sitePoint, 3);

            $officeVist = $tasks->where('create_task_id', 13)->count();
            $OfficePoint = $calculations->where('create_task_id', 13)->first()->point;
            $totalOfficePoint = number_format($officeVist * $OfficePoint, 3);

            $directMarketing = $tasks->where('create_task_id', 11)->count();

            $directMarketingPoint = $calculations->where('create_task_id', 11)->first()->point;
            $totalDirectMarketingPoint = number_format($directMarketing * $directMarketingPoint, 3);
            $mallCounter = $tasks->where('create_task_id', 10)->count();
            $mallCounterPoint = $calculations->where('create_task_id', 10)->first()->point;
            $totalMallCounterPoint = number_format($mallCounter * $mallCounterPoint, 3);

            $appointments = $tasks->where('create_task_id', 3)->count();
            $appointmentPoint = $calculations->where('create_task_id', 3)->first()->point;
            $totalAppointmentPoint = number_format($appointments * $appointmentPoint, 3);

            $virtual = $tasks->where('create_task_id', 12)->count();
            $virtualPoint = $calculations->where('create_task_id', 12)->first()->point;
            $totalVirtualPoint = number_format($virtual * $virtualPoint, 3);

            $followuptasks = $tasks->where('create_task_id', 19);
            $countWithNullImageAndDuration = $followuptasks->filter(function ($task) {
                return $task->image == null && $task->duration >= 120;
            })->count();

            $countWithNotNullImageAndTeamLeaderApprove = $followuptasks->filter(function ($task) {
                return $task->image != null && $task->team_leader_approved == 1;
            })->count();
            $followup = $countWithNullImageAndDuration + $countWithNotNullImageAndTeamLeaderApprove;
            $followupCount = $calculations->where('create_task_id', 19)->first()->point;
            $followupPoint = number_format($followup * $followupCount, 3);

            $fresh = $tasks->where('create_task_id', 15)->count();
            $freshRuno = $tasks->where('create_task_id', 17)->where('duration', '>', 30)->count();
            $freshCall = $fresh + $freshRuno;
            $freshCallPoint = $calculations->where('create_task_id', 15)->first()->point;
            $totalFreshCallPoint = number_format($freshCall * $freshCallPoint, 3);

            $freshNri = $tasks->where('create_task_id', 16)->count();
            $freshNriRuno = $tasks->where('create_task_id', 18)->where('duration', '>', 30)->count();
            $freshCallNriPoint = $calculations->where('create_task_id', 16)->first()->point;
            $freshCallNri = $freshNri + $freshNriRuno;
            $totalFreshCallNriPoint = number_format($freshCallNri * $freshCallNriPoint, 3);

            $connectHeads = $tasks->where('create_task_id', 14)->count();
            $connectHeadsPoint = $calculations->where('create_task_id', 14)->first()->point;
            $totalconnectHeadsPoint = number_format($connectHeads * $connectHeadsPoint, 3);

            $totalPoints = $totalSitepoint + $totalOfficePoint + $totalVirtualPoint + $totalDirectMarketingPoint + $totalMallCounterPoint + $totalAppointmentPoint + $followupPoint + $totalFreshCallNriPoint + $totalFreshCallPoint + $leadCalculation + $totalconnectHeadsPoint;

            $efficiency = ($uniquetasks > 0) ? $totalPoints / $uniquetasks : 0;

            $hourlyCounts[] = [
                    'Time' => $hour->format('H:i'),
                    'total_points' => $totalPoints,
                    'unique_followup_count' => $uniquetasks,
                    'efficiency' => strval(round($efficiency, 3)),
                ];
        }

        return response()->json([
                'message' => 'Success',
                'data' => [
                    'Work Efficiency' => $hourlyCounts,
                ],
            ]);
    }
}
