<?php

namespace App\Api\Http\Controllers\Api\V2\Proposal;

use App\Actions\VerifySale\RetailVerifySaleApiAction;
use App\Api\Http\Requests\Proposal\ProposalRequest;
use App\Helpers\ProposalHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\Retail\RetailRequest;
use App\PreferredProject;
use App\Proposal;

class ProposalController extends Controller
{
    public function create(ProposalRequest $request, ProposalHelper $ProposalHelper)
    {
        $project = PreferredProject::find($request->project_id);
        if ($project->proposal_type == 3) {
            $proposal = $ProposalHelper->createProposal($request);
        }

        if ($project->proposal_type == 2) {
            $proposal = $ProposalHelper->createProposalCommercial($request);
        }
        if ($proposal) {
            return response()->json([
                'status' => true,
                'message' => 'Proposal Creation Successful',
                'pdf' => asset($proposal->file) ?? '',
            ]);
        } else {
            return response()->json([
            'status' => true,
            'message' => 'proposal creation failed',
        ]);
        }
    }
}
