<?php

namespace App\Api\Http\Controllers\Api\V2\Sale;

use App\Actions\VerifySale\RetailVerifySaleApiAction;
use App\Actions\VerifySale\VerifySaleApiAction;
use App\Api\Http\Requests\Sale\SaleRequest;
use App\Api\Http\Requests\Sale\SaleVerifyRequest;
use App\Helpers\ProposalHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\Retail\RetailRequest;
use App\Lead;
use App\PreferredProject;
use App\Proposal;

class SaleController extends Controller
{
    public function RetailSale(SaleRequest $request, ProposalHelper $ProposalHelper)
    {
        try {
            $project = PreferredProject::find($request->project_id);
            if ($project->proposal_type == 3) {
                $proposal = $ProposalHelper->createProposal($request);
            }
            if ($proposal) {
                $lead = new Lead();

                $lead->enquirer_name = $request->name;
                $lead->pref_name = $request->pref_name;
                $lead->mobile = $request->phone;
                $lead->email = $request->email;
                $lead->phone_code = $request->phone_code;
                $lead->project_type = $project->project_type;
                $lead->preferred_project = $project->id;
                $lead->lead_date = date('Y-m-d');
                $lead->remarks = $request->remarks;
                $lead->created_by = auth()->user()->id;
                $lead->updated_by = auth()->user()->id;
                $lead->is_attended = 1;
                $lead->attended_by = auth()->user()->id;
                $lead->save();

                $data[] =
                    [
                        'lead_id' => strval($lead->id),
                        'proposal_id' => strval($proposal->id),
                        'share_price' => strval($project->share_amount),
                        'min_shares' => strval($project->min_shares),
                    ];

                return response()->json([
                    'status' => true,
                    'message' => 'Proposal Creation Successful',
                    'data' => $data,
                ]);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'Proposal Creation Failed',
                    'data' => [],
                ]);
            }
        } catch (\Throwable $th) {
            dd($th);

            return response()->json([
                'status' => false,
                'message' => 'Proposal Creation Failed',
                'data' => [],
            ]);
        }
    }

    public function storeRetailsale(RetailRequest $request, Proposal $proposal, RetailVerifySaleApiAction $RetailverifySaleAction)
    {
        $response = $RetailverifySaleAction->execute(collect($request->validated()), $proposal);

        if ($response) {
            return [
                'status' => true,
                'message' => 'Sale Added Successfully',
            ];
        }
        return [
            'status' => false,
            'message' => 'Something went wrong',
        ];
    }

    public function storeSaleVerify(SaleVerifyRequest $request, Proposal $proposal, VerifySaleApiAction $verifySaleAction)
    {
        $response = $verifySaleAction->execute(collect($request->validated()), $proposal);

        if ($response) {
            return [
                'status' => true,
                'message' => 'Sale Added Successfully',
            ];
        }
        return [
            'status' => false,
            'message' => 'Something went wrong',
        ];
    }
}
