<?php

namespace App\Api\Http\Controllers\Api\V2\Users;

use App\Api\Http\Requests\Task\TaskListRequest;
use App\Api\Http\Resources\Tasks\TaskCollection;
use App\Api\Http\Resources\User\UserCollection;
use App\Http\Controllers\Controller;
use App\Task;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Spatie\QueryBuilder\AllowedFilter;
use Spatie\QueryBuilder\QueryBuilder;

class UsersController extends Controller
{


    public function UsersAllList(Request $request)
    {
        $branchHeadId = $request->branch_head_id;
        if($branchHeadId){
            $branchHead = User::find($branchHeadId);
            $branchId = $branchHead->branch_id;
        }
        else{
            $branchId = '';
        }
        

        $teamleaders = User::with(['roles'])
            ->whereHas('roles', function ($q) {
                $q->where('role_id', 8);
            })
            ->when($branchId , function ($query) use ($branchId) {
                $query->where('branch_id',$branchId);
            })
            ->when($request->team_leader_id , function ($query) use ($request) {
                $query->where('reporting_to',$request->team_leader_id);
            })
            ->when(auth()->user()->hasRole('team-leader'), function ($query) {
                $query->where('reporting_to',auth()->user()->id);
            })
            ->when(auth()->user()->hasRole('sales-head'), function ($query) {
                $query->where('branch_id', auth()->user()->branch_id);
            })
            ->whereNotIn('id', [282, 276, 269,314])
            ->where('status', 1)
            ->get();

            $all = [
                'id' =>'',
                'name' => 'All',
                'email' => '',
                'mobile' => '',
                'image' =>  '',
            ];
            $merge = array_merge([$all], $teamleaders->toArray());
            $data = array_map(function ($item) {
                return is_array($item) ? (object)$item : $item;
            }, $merge);
             
        return $this->success(
            'users',
            new UserCollection($data)
        );
    }

    public function branchHeadsList()
    {
        $branchHeads = User::with(['roles'])
            ->whereHas('roles', function ($q) {
                $q->where('role_id', 3);
            })
            ->where('status', 1)

            ->get();
            $all = [
                'id' =>'',
                'name' => 'All',
                'email' => '',
                'mobile' => '',
                'image' =>  '',
            ];
            $merge = array_merge([$all], $branchHeads->toArray());
            $data = array_map(function ($item) {
                return is_array($item) ? (object)$item : $item;
            }, $merge);
        return $this->success(
            'branch heads',
            new UserCollection($data)
        );
    }

    public function getBranchTeamLeaders(Request $request)
    {
        $customOrder = [6, 5, 1, 2];

        $branchHeadId = $request->branch_head_id;
        if($branchHeadId){
            $branchHead = User::find($branchHeadId);
            $branchId = $branchHead->branch_id;
        }
        else{
            $branchId = '';
        }
       

        $teamleaders = User::with(['roles'])
        ->whereHas('roles', function ($q) {
            $q->where('role_id', 7);
        })
        ->when($branchId, function ($query) use ($branchId) {
            $query->where('branch_id', $branchId);
        })
        ->whereNotIn('id', [282, 276, 269])
        ->where('is_show',1)
        ->where('status', 1)
        ->when(auth()->user()->hasRole('sales-head'), function ($query) {
            $query->where('branch_id', auth()->user()->branch_id);
        })
        ->orderByRaw('
            CASE 
                WHEN branch_id = ? THEN 1
                WHEN branch_id = ? THEN 2
                WHEN branch_id = ? THEN 3
                WHEN branch_id = ? THEN 4
                ELSE 5
            END
        ', $customOrder)
        ->orderBy('name', 'asc')
        ->get();
            $all = [
                'id' =>'',
                'name' => 'All',
                'email' => '',
                'mobile' => '',
                'image' =>  '',
            ];
            $merge = array_merge([$all], $teamleaders->toArray());
            $data = array_map(function ($item) {
                return is_array($item) ? (object)$item : $item;
            }, $merge);


        return $this->success(
            'team leaders',
            new UserCollection($data)
        );
    }
}
