<?php

namespace App\Api\Http\Controllers\Api\V2\salesHistory;
use App\Http\Controllers\Controller;
use App\SalesActivity;
use App\SalesHistory;

class SalesHistoryController extends Controller
{
    public function index()
    {
        $sales = SalesHistory::when(auth()->user()->hasRole('sales-head'), function ($query) {
            $query->where('branch_head_id', auth()->user()->id);
        })->when(auth()->user()->hasRole('executive'), function ($query) {
            $query->where('sales_person_id', auth()->user()->id);
        })->when(auth()->user()->hasRole('team-leader'), function ($query) {
            $query->where('team_leader_id', auth()->user()->id);
        })->with(['getProject','getSalesPerson','getTeamLeader','getBranchHead','getSaleActivity'])->get();

        foreach ($sales as $sale) {
            if($sale->town !== null && $sale->town != 1){
                $town = $sale->town;
            }
            else{
                $town = '';
            }

            if($sale->district !== null && $sale->district != 1){
                $district = $sale->district;                                                     
            }
            else{
                $district = '';
            }
            if($sale->sale_id !== null && $sale->sale_id != 0){
                 $sale_id = $sale->sale_id;
                
            }
            else{
                $sale_id = '';
            }
           
            $data[] = [
                'id' =>$sale->id ?? '',
                'name' => $sale->customer_name ?? '',
                'project_name' => $sale->getProject  ?  $sale->getProject->project_name :'', 
                'unit' => $sale->unit_number,
                'gender' => $sale->gender ?? '', 
                'dob' => $sale->dob ?? '', 
                'town' => $town ?? '',
                'district' =>  $district ?? '',
                'quarter' => $sale->quarter ?? '', 
                'sale_value' => $sale->sale_value ?? '',
                'branch_head' => $sale->getBranchHead ? $sale->getBranchHead->name : '', 
                'team_leader' => $sale->getTeamLeader ? $sale->getTeamLeader->name : '', 
                'sales_person' => $sale->getSalesPerson ? $sale->getSalesPerson->name : '', 
                'sale_date' => $sale->sale_date ?? '',
                'verified_status' =>  strval($sale_id)?? '',
                'phone' => $sale->getSaleActivity->getLeads->mobile ?? '',
                'phone_code' =>  $sale->getSaleActivity->getLeads->phone_code  ?? '',
            ];
          
        }
            
        return response()->json([
            'status' => true,
            'message' => "sale history customers",
            'data' => $data ?? []
        ]);
    }
    
}
