<?php

namespace App\Api\Http\Requests\Lead;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class LeadListRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(Request $request): array
    {
        return [
            'list' => 'nullable|integer',
            'from_date' => ($request->list == 4) ? 'required|date' : '',
            'to_date' => ($request->list == 4) ? 'required|date' : '',
        ];
    }
}
