<?php

namespace App\Api\Http\Requests\Lead;

use Illuminate\Foundation\Http\FormRequest;

class LeadRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'enquirer_name' => [
                'required',
            ],
            'email' => [
                'nullable',
                'required_without:mobile',
                'email',
                'max:255',
            ],
            'mobile' => [
                'nullable',
                'required_without:email',
                'digits_between:5,13',
                'numeric'
            ],
            'phone_code' => [
                'nullable',
                'required_with:mobile',
            ],
            'alternative_mobile' =>
                [
                    'nullable',
                ],
            'source' => [
                'required',
            ],
            'budget' => [
                'nullable',
            ],
            'project_type' => [
                'required',
            ],
            'preferred_project' => [
                'required',
            ],
            'remarks' => [
                'required',
            ],
            'lead_stage' => [
                'nullable',
            ],
            'lead_category' => [
                'nullable',
            ],
            'allocate_to' => [
                'nullable',
            ],
             'location_id'=> [
                    'required'
             ],
             'location_name' => [
                'required_if:location_id,15,16'
             ],
             'duplicate_status'=>[
                'nullable'

             ]
            
        ];
    }
}
