<?php

namespace App\Api\Http\Requests\Lead;

use Illuminate\Foundation\Http\FormRequest;

class UnattendedLeadRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'lead_stage_id' => ['nullable'],
            'lead_category' => ['nullable'],
            'comment' => ['nullable'],
            'location_id' => ['nullable'],
            'location_name' => ['required_if:location_id,15,16'],
            'create_task_id' => ['nullable'],
            'reminder' => ['nullable'],
            'budget' => ['nullable'],
            'project_type' => ['nullable'],
            'preferred_project' => ['nullable'],
            'profession' => ['nullable'],
            'investment_purpose' => ['nullable'],
            'residential_status' => ['nullable'],
            'job' => ['nullable'],
        ];
    }
}
