<?php

namespace App\Api\Http\Requests\Lead;

use Illuminate\Foundation\Http\FormRequest;

class WhatsappLeadRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => [
                'required',
            ],
           
            'mobile' => [
                'required',
                'required_without:email',
                'digits_between:5,13',
                'numeric'
            ],
            'phone_code' => [
                'nullable'
                ,
            ],
         
            
        ];
    }
}
