<?php

namespace App\Api\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class LoginRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'username' => [
                'required',
                'exists:users,username',
            ],
            'password' => [
                'required',
                'string',
                'min:8',
            ],
            'device_type' => [
                'nullable',
                Rule::in('android', 'ios', 'web')
            ],
            'device_name' => 'nullable',
            'device_id' => 'nullable',
            'push_token' => 'nullable'
        ];
    }
}
