<?php

namespace App\Api\Http\Requests\Proposal;

use Illuminate\Foundation\Http\FormRequest;

class ProposalRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'project_id' => [
                'required',
            ],
            'pref_name' => [
                'required',
            ],
            'name' => [
                'required',
            ],

            'email' => [
                'nullable',

                'email',
                'max:255',
            ],
            'phone' => [
                'nullable',
                'digits_between:8,13',
                'numeric',
            ],
            'proposal_type' => [
                'required',
            ],
             'option_1' => [
                'required_if:
                 proposal_type,3',
                ],

             'option_2' => [
                'required_if:
                 proposal_type,3',
                 ],
             'option_3' => [
                   'required_if:
                    proposal_type,3', ],
             'proposal_unit_id' => [
                   'required_if:
                    proposal_type,2',
            ],
            'proposal_unit_id' => [
                'required_if:
                 proposal_type,2',
         ],
         'type' => [
            'required_if:
            proposal_type,2', ],
        'sba_area' => [
                'required_if:
                proposal_type,2', ],
        'cost_apartment' => [
            'required_if:
                proposal_type,2',
        ],
        'grand_total' => [
            'nullable',
        ],
        'sba_area' => [
            'nullable',
        ],
        'carpet_area' => [
            'nullable',
        ],
        'association_deposit' => [
            'nullable',
        ],
];
    }
}
