<?php

namespace App\Api\Http\Requests\Sale;

use Illuminate\Foundation\Http\FormRequest;

class SaleRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => [
                'required',
            ],
            'email' => [
                'nullable',
                'required_without:phone',
                'email',
                'max:255',
            ],
            'project_id' => [
                'required',
            ],
            'phone' => [
                'nullable',
                'required_without:email',
                'digits_between:5,13',
                'numeric',
            ],
            'phone_code' => [
                'nullable',
                'required_with:phone',
            ],
            'proposal_type' => [
                'required',
            ],
             'option_1' => [
                'required_if:
                 proposal_type,3',
                ],

             'option_2' => [
                'required_if:
                 proposal_type,3',
                 ],
             'option_3' => [
                   'required_if:
                    proposal_type,3', ],
         ];
    }
}
