<?php

namespace App\Api\Http\Requests\Sale;

use App\Note;
use Illuminate\Foundation\Http\FormRequest;

class SaleVerifyRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $clientDocuments = Note::where('lead_id', $this->input('lead_id'))->pluck('type')->toArray();   
        $requestFields = [
            'driving_license_back_side',
            'passport',
            'election_id_back_side',
            'driving_license_front_side',
            'election_id_front_side',
            'aadhaar_back_side',
            'aadhaar_front_side',
            'pan_card_back_side',
            'pan_card_front_side'
        ];
        $anyKeyInClientDocs = collect($requestFields)->intersect($clientDocuments)->isNotEmpty();
        if(auth()->user()->hasRole('super-admin')){
            $baseValidationRules = ['nullable'];
        }else{
            $baseValidationRules = $anyKeyInClientDocs ? ['nullable'] : ['required_without_all:' . implode(',', $requestFields)];
        }
        $validationRules = array_fill_keys($requestFields, $baseValidationRules);
        return [
            'lead_id' => ['nullable'],
            'proposal_id' => ['nullable'],
            'pref_name' => ['required'],
            'name' => ['required'],
            'email' => ['nullable', 'email'],
            'phone' => 'required|min:8|max:13',
            'alt_mobile' => 'nullable|min:10|max:13',
            'whatsapp_no' => 'nullable|min:10|max:13',
            'gender' => ['nullable'],
            'address' => ['required'],
            'pin' => 'nullable|digits:6',
            'city' => ['required'],
            'preferred_project' => ['required'],
            'project_id' => ['nullable'],
            'unit_id' => ['required'],
            'grand_total' => ['required'],
            'on_booking_grand_total' => ['nullable'],
            'on_agreement_grand_total' => ['nullable'],
            'balance' => ['nullable'],
            'mode_of_payment' => ['required'],
            'grand_total' => ['required'],
            'cq_amount' => ['required_if:mode_of_payment,Cheque'],
            'cheque_submit_date' => ['required_if:mode_of_payment,Cheque'],
            'cheque_date' => ['required_if:mode_of_payment,Cheque'],
            'chbank' => ['required_if:mode_of_payment,Cheque'],
            'cheque_no' => ['required_if:mode_of_payment,Cheque'],
            'upiamnt' => ['required_if:mode_of_payment,UPI'],
            'upi_reference_no' => ['required_if:mode_of_payment,UPI'],
            'upi_paid_date' => ['required_if:mode_of_payment,UPI'],
            'upi_provider' => ['required_if:mode_of_payment,UPI'],
            'dd_amount' => ['required_if:mode_of_payment,DD'],
            'dd_no' => ['required_if:mode_of_payment,DD'],
            'dd_date' => ['required_if:mode_of_payment,DD'],
            'dd_bank' => ['required_if:mode_of_payment,DD'],
            'eft_amount' => ['required_if:mode_of_payment,EFT'],
            'eft_bank' => ['required_if:mode_of_payment,EFT'],
            'fund_transfer_date' => ['required_if:mode_of_payment,EFT'],
            'sale_date' => ['required'],
            'sale_owner' => ['required'],
            'pan_card' => ['nullable'],
            'pan_card_front_side' => $validationRules['pan_card_front_side'],
            'pan_card_back_side' => $validationRules['pan_card_back_side'],
            'aadhaar_front_side' => $validationRules['aadhaar_front_side'],
            'aadhaar_back_side' => $validationRules['aadhaar_back_side'],
            'election_id_front_side' => $validationRules['election_id_front_side'],
            'election_id_back_side' => $validationRules['election_id_back_side'],
            'driving_license_front_side' => $validationRules['driving_license_front_side'],
            'driving_license_back_side' => $validationRules['driving_license_back_side'],
            'passport' => $validationRules['passport'],
            'payment_file' => ['required'],
            'pan_card_number' => ['nullable'],
            'sale_ref_number' => ['nullable'],
         ];
    }
}
