<?php

namespace App\Api\Http\Requests\Task;

use Illuminate\Foundation\Http\FormRequest;

class TaskActionRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
//            'lead_id' => [
//                'required',
//            ],
//            'create_task_id'  => [
//                'required',
//            ],
//            'followup_by' =>  [
//                'required',
//            ],
//            'lead_category' => [
//                'required',
//            ],
//            'followup_type' =>
//            [
//                'nullable',
//            ],
//            'schedule_date' => [
//                'required',
//            ],
//            'schedule_time' => [
//                'required',
//            ],
//            'reminder' => [
//                'required',
//            ],
//            'project' => [
//                'required',
//            ],
//            'lead_stage' => [
//                'required',
//            ],
//            'remarks' => [
//                'required',
//            ],
//            'budget' => [
//                'nullable',
//            ],
            'lead_id' => ['required'],
            'create_task_id' => ['required'],
            'followup_by' => [
                'required_if:create_task_id,1',
                'required_if:create_task_id,2'
            ],
            'lead_category' => [
                'nullable',
                
            ],
            'project' => [
                'nullable'
            ],
            'followup_type' => [
                'required_if:create_task_id,1'
            ],
            'schedule_date' => [
                'required_unless:create_task_id,5,7,8,9'
            ],
            'reminder' => [
                'required_unless:create_task_id,5,7,8,9'
            ],
            'schedule_time' => [
                'required_unless:create_task_id,5,7,8,9'
            ],
            'lead_stage' => [
                'nullable'
            ],
            'budget' => ['nullable'],
            'remarks' => ['required'],
        ];
    }
}
